/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.plugins;

import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.BaseMultiTableInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.Values;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import top.tangyh.basic.database.plugins.TenantLineHelper;

public class LampTenantLineInnerInterceptor
extends BaseMultiTableInnerInterceptor
implements InnerInterceptor {
    private TenantLineHandler tenantLineHandler;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (!TenantLineHelper.willTenantLine(ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), null));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (!TenantLineHelper.willTenantLine(ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), null));
        }
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        String whereSegment = (String)obj;
        this.processSelectBody(select, whereSegment);
        List withItemsList = select.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(withItem -> this.processSelectBody((Select)withItem.getSelect(), whereSegment));
        }
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        Select select;
        if (this.tenantLineHandler.ignoreTable(insert.getTable().getName())) {
            return;
        }
        ExpressionList columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.tenantLineHandler.getTenantIdColumn();
        if (this.tenantLineHandler.ignoreInsert((List)columns, tenantIdColumn)) {
            return;
        }
        columns.add(new Column(tenantIdColumn));
        Expression tenantId = this.tenantLineHandler.getTenantId();
        List duplicateUpdateColumns = insert.getDuplicateUpdateSets();
        if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateColumns)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new StringValue(tenantIdColumn));
            equalsTo.setRightExpression(tenantId);
            duplicateUpdateColumns.add(new UpdateSet(new Column(tenantIdColumn), tenantId));
        }
        if ((select = insert.getSelect()) instanceof PlainSelect) {
            this.processInsertSelect(select, (String)obj);
        } else if (insert.getValues() != null) {
            Values values = insert.getValues();
            ExpressionList expressions = values.getExpressions();
            if (expressions instanceof ParenthesedExpressionList) {
                expressions.addExpression(tenantId);
            } else if (CollectionUtils.isNotEmpty((Collection)expressions)) {
                int len = expressions.size();
                for (int i = 0; i < len; ++i) {
                    Expression expression = (Expression)expressions.get(i);
                    if (expression instanceof ParenthesedExpressionList) {
                        ((ParenthesedExpressionList)expression).addExpression(tenantId);
                        continue;
                    }
                    expressions.add((Object)tenantId);
                }
            } else {
                expressions.add((Object)tenantId);
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Expression expression;
        Table table = update.getTable();
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return;
        }
        List sets = update.getUpdateSets();
        if (!CollectionUtils.isEmpty((Collection)sets)) {
            sets.forEach(us -> us.getValues().forEach(ex -> {
                if (ex instanceof Select) {
                    this.processSelectBody((Select)ex, (String)obj);
                }
            }));
        }
        if ((expression = this.andExpression(table, update.getWhere(), (String)obj)) != null) {
            update.setWhere(expression);
        }
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        if (this.tenantLineHandler.ignoreTable(delete.getTable().getName())) {
            return;
        }
        Expression expression = this.andExpression(delete.getTable(), delete.getWhere(), (String)obj);
        if (expression != null) {
            delete.setWhere(expression);
        }
    }

    protected void processInsertSelect(Select selectBody, String whereSegment) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem instanceof Table) {
                this.processPlainSelect(plainSelect, whereSegment);
                this.appendSelectItem(plainSelect.getSelectItems());
            } else if (fromItem instanceof Select) {
                Select subSelect = (Select)fromItem;
                this.appendSelectItem(plainSelect.getSelectItems());
                this.processInsertSelect(subSelect, whereSegment);
            }
        } else if (selectBody instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)selectBody;
            this.processInsertSelect(parenthesedSelect.getSelect(), whereSegment);
        }
    }

    protected void appendSelectItem(List<SelectItem<?>> selectItems) {
        SelectItem<?> item;
        Expression expression;
        if (CollectionUtils.isEmpty(selectItems)) {
            return;
        }
        if (selectItems.size() == 1 && (expression = (item = selectItems.get(0)).getExpression()) instanceof AllColumns) {
            return;
        }
        selectItems.add(new SelectItem((Expression)new Column(this.tenantLineHandler.getTenantIdColumn())));
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName()).append(".");
        }
        column.append(this.tenantLineHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public void setProperties(Properties properties) {
        PropertyMapper.newInstance((Properties)properties).whenNotBlank("tenantLineHandler", ClassUtils::newInstance, this::setTenantLineHandler);
    }

    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return null;
        }
        if (this.tenantLineHandler.getTenantId() == null) {
            return null;
        }
        return new EqualsTo((Expression)this.getAliasColumn(table), this.tenantLineHandler.getTenantId());
    }

    @Generated
    public TenantLineHandler getTenantLineHandler() {
        return this.tenantLineHandler;
    }

    @Generated
    public void setTenantLineHandler(TenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }

    @Generated
    public LampTenantLineInnerInterceptor() {
    }

    @Generated
    public LampTenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }

    @Generated
    public String toString() {
        return "LampTenantLineInnerInterceptor(super=" + super.toString() + ", tenantLineHandler=" + this.getTenantLineHandler() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LampTenantLineInnerInterceptor)) {
            return false;
        }
        LampTenantLineInnerInterceptor other = (LampTenantLineInnerInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantLineHandler this$tenantLineHandler = this.getTenantLineHandler();
        TenantLineHandler other$tenantLineHandler = other.getTenantLineHandler();
        return !(this$tenantLineHandler == null ? other$tenantLineHandler != null : !this$tenantLineHandler.equals(other$tenantLineHandler));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LampTenantLineInnerInterceptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantLineHandler $tenantLineHandler = this.getTenantLineHandler();
        result = result * 59 + ($tenantLineHandler == null ? 43 : $tenantLineHandler.hashCode());
        return result;
    }
}

