/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.datasource.defaults;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusPropertiesCustomizer;
import com.p6spy.engine.spy.P6DataSource;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import top.tangyh.basic.database.datasource.BaseDatabaseConfiguration;
import top.tangyh.basic.database.properties.DatabaseProperties;

public abstract class BaseMasterDatabaseConfiguration
extends BaseDatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BaseMasterDatabaseConfiguration.class);
    public static final String DATABASE_PREFIX = "master";

    public BaseMasterDatabaseConfiguration(MybatisPlusProperties properties, DatabaseProperties databaseProperties, ObjectProvider<Interceptor[]> interceptorsProvider, ObjectProvider<TypeHandler[]> typeHandlersProvider, ObjectProvider<LanguageDriver[]> languageDriversProvider, ResourceLoader resourceLoader, ObjectProvider<DatabaseIdProvider> databaseIdProvider, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider, ObjectProvider<List<MybatisPlusPropertiesCustomizer>> mybatisPlusPropertiesCustomizerProvider, ApplicationContext applicationContext) {
        super(properties, databaseProperties, interceptorsProvider, typeHandlersProvider, languageDriversProvider, resourceLoader, databaseIdProvider, configurationCustomizersProvider, mybatisPlusPropertiesCustomizerProvider, applicationContext);
    }

    @Bean(value={"masterSqlSessionTemplate"})
    public SqlSessionTemplate getSqlSessionTemplate(@Qualifier(value="masterSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        ExecutorType executorType = this.properties.getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplate(sqlSessionFactory, executorType);
        }
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean(name={"masterDruidDataSource"}, initMethod="init")
    public DataSource druidDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"masterDataSource"})
    public DataSource dataSource(@Qualifier(value="masterDruidDataSource") DataSource dataSource) {
        if (this.databaseProperties.getP6spy().booleanValue()) {
            return new P6DataSource(dataSource);
        }
        return dataSource;
    }

    @Bean(value={"masterSqlSessionFactory"})
    @Primary
    public SqlSessionFactory getSqlSessionFactory(@Qualifier(value="masterDataSource") DataSource dataSource) throws Exception {
        return super.sqlSessionFactory(dataSource);
    }

    @Bean(name={"masterTransactionManager"})
    @Primary
    public DataSourceTransactionManager dsTransactionManager(@Qualifier(value="masterDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

