/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.parser.NodeParser;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.base.entity.TreeEntity;

public final class TreeUtil {
    public static final String TREE_SPLIT = "/";
    public static final Long DEF_PARENT_ID = 0L;
    private static final int TOP_LEVEL = 1;

    private TreeUtil() {
    }

    public static String getTreePath(String parentTreePath, Long parentId) {
        return parentTreePath + parentId + TREE_SPLIT;
    }

    public static String buildTreePath(Long id) {
        return TREE_SPLIT + id + TREE_SPLIT;
    }

    public static boolean isRoot(Long id) {
        return id == null || DEF_PARENT_ID.equals(id);
    }

    public static <E extends TreeEntity<E, ? extends Serializable>> List<E> buildTree(Collection<E> treeList) {
        if (CollUtil.isEmpty(treeList)) {
            return Collections.emptyList();
        }
        ArrayList<Serializable> selfIdEqSelfParent = new ArrayList<Serializable>();
        for (TreeEntity parent : treeList) {
            Serializable id = (Serializable)parent.getId();
            for (TreeEntity children : treeList) {
                if (parent != children) {
                    if (!id.equals(children.getParentId())) continue;
                    parent.initChildren();
                    parent.getChildren().add(children);
                    continue;
                }
                if (!id.equals(parent.getParentId())) continue;
                selfIdEqSelfParent.add(id);
            }
        }
        ArrayList<TreeEntity> trees = new ArrayList<TreeEntity>();
        List<Serializable> allIds = treeList.stream().map(SuperEntity::getId).toList();
        for (TreeEntity baseNode : treeList) {
            if (allIds.contains(baseNode.getParentId()) && !selfIdEqSelfParent.contains(baseNode.getParentId())) continue;
            trees.add(baseNode);
        }
        return trees;
    }

    public static Long getTopNodeId(String treePath) {
        Object[] pathIds = StrUtil.splitToArray((CharSequence)treePath, (CharSequence)TREE_SPLIT);
        if (ArrayUtil.isNotEmpty((Object[])pathIds)) {
            return Convert.toLong((Object)pathIds[1]);
        }
        return null;
    }

    public static <T extends TreeNode<Long>> List<Tree<Long>> build(List<T> list) {
        return TreeUtil.build(list, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public static <T extends TreeNode<Long>> List<Tree<Long>> build(List<T> list, TreeNodeConfig treeNodeConfig) {
        return TreeUtil.build(list, DEF_PARENT_ID, treeNodeConfig);
    }

    public static <T extends TreeNode<E>, E> List<Tree<E>> build(List<T> list, E rootId) {
        return TreeUtil.build(list, rootId, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public static <T extends TreeNode<E>, E> List<Tree<E>> build(List<T> list, E rootId, TreeNodeConfig treeNodeConfig) {
        return cn.hutool.core.lang.tree.TreeUtil.build(list, rootId, (TreeNodeConfig)treeNodeConfig, new FsNodeParser());
    }

    public static <T extends TreeNode<Long>> List<Tree<Long>> build(List<T> list, NodeParser<T, Long> nodeParser) {
        return cn.hutool.core.lang.tree.TreeUtil.build(list, (Object)DEF_PARENT_ID, (TreeNodeConfig)TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static class FsNodeParser<T extends TreeNode<E>, E>
    implements NodeParser<T, E> {
        public void parse(T treeNode, Tree<E> tree) {
            tree.setId(treeNode.getId());
            tree.setParentId(treeNode.getParentId());
            tree.setWeight(treeNode.getWeight());
            tree.setName(treeNode.getName());
            Map extra = treeNode.getExtra();
            if (MapUtil.isNotEmpty((Map)extra)) {
                extra.forEach((arg_0, arg_1) -> tree.putExtra(arg_0, arg_1));
            }
        }
    }
}

