/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import java.util.regex.Pattern;

public final class ValidatorUtil {
    public static final String REGEX_USERNAME = "^[a-zA-Z0-9_]\\w{5,254}$";
    public static final Pattern PATTERN_USERNAME = Pattern.compile("^[a-zA-Z0-9_]\\w{5,254}$");
    public static final String REGEX_PASSWORD = "^[a-zA-Z0-9]{5,15}$";
    public static final Pattern PATTERN_PASSWORD = Pattern.compile("^[a-zA-Z0-9]{5,15}$");
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final Pattern PATTERN_EMAIL = Pattern.compile("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$");
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5]$";
    public static final Pattern PATTERN_CHINESE = Pattern.compile("^[\u4e00-\u9fa5]$");
    public static final String REGEX_ID_CARD = "(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])";
    public static final Pattern PATTERN_ID_CARD = Pattern.compile("(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])");
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
    public static final Pattern PATTERN_URL = Pattern.compile("http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?");
    public static final String REGEX_IP_ADDRESS = "(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
    public static final Pattern PATTERN_IP_ADDRESS = Pattern.compile("(2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})");
    public static final String REGEX_MOBILE = "^(1)\\d{10}$";
    public static final Pattern PATTERN_MOBILE = Pattern.compile("^(1)\\d{10}$");

    private ValidatorUtil() {
    }

    public static boolean isUserName(String value) {
        return PATTERN_USERNAME.matcher(value).matches();
    }

    public static boolean isEmail(String value) {
        return PATTERN_EMAIL.matcher(value).matches();
    }

    public static boolean isIdCard(String value) {
        return PATTERN_ID_CARD.matcher(value).matches();
    }

    public static boolean isPassword(String value) {
        return PATTERN_PASSWORD.matcher(value).matches();
    }

    public static boolean isMobile(String value) {
        return PATTERN_MOBILE.matcher(value).matches();
    }

    public static boolean isIpAddress(String value) {
        return PATTERN_IP_ADDRESS.matcher(value).matches();
    }

    public static boolean isUrl(String value) {
        return PATTERN_URL.matcher(value).matches();
    }

    public static boolean isChinese(String value) {
        return PATTERN_CHINESE.matcher(value).matches();
    }
}

