/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.model.RemoteData;
import top.tangyh.basic.utils.DefValueHelper;

public final class StrHelper {
    private static final Logger log = LoggerFactory.getLogger(StrHelper.class);

    private StrHelper() {
    }

    public static String getOrDef(String val, String def) {
        return DefValueHelper.getOrDef(val, def);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object)css)) {
            return true;
        }
        return Stream.of(css).anyMatch(CharSequenceUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        if (ObjectUtil.isEmpty((Object)css)) {
            return false;
        }
        return Stream.of(css).allMatch(CharSequenceUtil::isNotBlank);
    }

    public static String keywordConvert(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return "";
        }
        value = value.replaceAll("%", "\\\\%");
        value = value.replaceAll("_", "\\\\_");
        return value;
    }

    public static Object keywordConvert(Object value) {
        if (value instanceof String) {
            return StrHelper.keywordConvert(String.valueOf(value));
        }
        if (value instanceof RemoteData) {
            RemoteData temp = (RemoteData)value;
            if (temp.getKey() instanceof String && ObjectUtil.isNotEmpty((Object)temp.getKey())) {
                temp.setKey((Object)StrHelper.keywordConvert(String.valueOf(temp.getKey())));
                return temp;
            }
            return value;
        }
        return value;
    }

    public static String like(Object value, SqlLike sqlType) {
        return SqlUtils.concatLike((Object)StrHelper.keywordConvert(String.valueOf(value)), (SqlLike)sqlType);
    }

    public static RemoteData<String, ?> like(RemoteData<String, ?> temp, SqlLike sqlType) {
        if (StrUtil.isEmpty((CharSequence)((CharSequence)temp.getKey()))) {
            return temp;
        }
        String oldValue = StrHelper.keywordConvert((String)temp.getKey());
        temp.setKey((Object)SqlUtils.concatLike((Object)oldValue, (SqlLike)sqlType));
        return temp;
    }

    public static String fullLike(String value) {
        return StrHelper.like(value, SqlLike.DEFAULT);
    }
}

