/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.converter;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.exception.BizException;
import top.tangyh.basic.model.RemoteData;

public class RemoteDataDeserializer
extends StdDeserializer<RemoteData<?, ?>> {
    private static final Logger log = LoggerFactory.getLogger(RemoteDataDeserializer.class);
    public static final RemoteDataDeserializer INSTANCE = new RemoteDataDeserializer();
    private static final String REMOTE_DATA_KEY_FIELD = "key";
    private static final String REMOTE_DATA_DATA_FIELD = "data";

    public RemoteDataDeserializer() {
        super(RemoteData.class);
    }

    public RemoteData<?, ?> deserialize(JsonParser jp, DeserializationContext context) {
        try {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String currentName = jp.currentName();
            Object currentValue = jp.getCurrentValue();
            String keyVal = this.getValByNode(node, REMOTE_DATA_KEY_FIELD);
            String dataVal = this.getValByNode(node, REMOTE_DATA_DATA_FIELD);
            if (currentValue == null) {
                return null;
            }
            Field field = ReflectUtil.getField(currentValue.getClass(), (String)currentName);
            if (field == null) {
                return null;
            }
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                return new RemoteData(this.convert(pt.getActualTypeArguments()[0], keyVal), this.convert(pt.getActualTypeArguments()[1], dataVal));
            }
            return null;
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790RemoteData\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
            throw BizException.wrap("\u89e3\u6790RemoteData\u5b57\u6bb5\u5931\u8d25:" + e.getMessage(), new Object[0]);
        }
    }

    protected String getValByNode(JsonNode node, String fieldName) {
        JsonNode keyNode = node.get(fieldName);
        return keyNode != null ? keyNode.asText() : node.asText();
    }

    protected <T> T convert(Type type, Object val) {
        if (val == null) {
            return null;
        }
        if ("null".equals(val)) {
            return null;
        }
        if ("".equals(val)) {
            if ("java.lang.String".equals(type.getTypeName())) {
                return (T)"";
            }
            return null;
        }
        return (T)Convert.convert((Type)type, (Object)val);
    }
}

