/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.StringUtils;

public class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);
    private static final ResourcePatternResolver RESOURCE_PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private static final MetadataReaderFactory METADATA_READER_FACTORY = new CachingMetadataReaderFactory();

    private static Set<Class<?>> scanClasses(String packagePatterns, Class<?> assignableType) throws IOException {
        String[] packagePatternArray;
        HashSet classes = new HashSet();
        for (String packagePattern : packagePatternArray = StringUtils.tokenizeToStringArray((String)packagePatterns, (String)",; \t\n")) {
            Resource[] resources;
            for (Resource resource : resources = RESOURCE_PATTERN_RESOLVER.getResources("classpath*:" + org.springframework.util.ClassUtils.convertClassNameToResourcePath((String)packagePattern) + "/**/*.class")) {
                try {
                    ClassMetadata classMetadata = METADATA_READER_FACTORY.getMetadataReader(resource).getClassMetadata();
                    Class clazz = Resources.classForName((String)classMetadata.getClassName());
                    if (assignableType != null && !assignableType.isAssignableFrom(clazz)) continue;
                    classes.add(clazz);
                }
                catch (Throwable e) {
                    log.warn("Cannot load the '{}'. Cause by ", (Object)resource, (Object)e);
                }
            }
        }
        return classes;
    }

    public static Set<Class<?>> scanPackage(String packageName, Predicate<Class<?>> classFilter) {
        Set<Object> classes;
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)packageName)) {
            return Collections.emptySet();
        }
        if (packageName.contains("*") && !packageName.contains(",") && !packageName.contains(";")) {
            classes = ClassUtils.scanClasses(packageName, null);
        } else {
            classes = new HashSet();
            String[] packageNameArray = StringUtils.tokenizeToStringArray((String)packageName, (String)",; \t\n");
            Assert.notNull((Object)packageNameArray, (String)("not find packageName:" + packageName), (Object[])new Object[0]);
            Stream.of(packageNameArray).forEach(typePackage -> {
                try {
                    Set<Class<?>> scanTypePackage = ClassUtils.scanClasses(typePackage, null);
                    classes.addAll(scanTypePackage);
                }
                catch (IOException e) {
                    throw new MybatisPlusException("Cannot scan class in '[" + typePackage + "]' package", (Throwable)e);
                }
            });
        }
        return classes.stream().filter(classFilter).collect(Collectors.toSet());
    }
}

