/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import top.tangyh.basic.exception.ArgumentException;

public class ArgumentAssert {
    public static <X extends Throwable> void isTrue(boolean expression, Supplier<? extends X> supplier) throws X {
        if (!expression) {
            throw (Throwable)supplier.get();
        }
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws ArgumentException {
        ArgumentAssert.isTrue(expression, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static void isTrue(boolean expression) throws ArgumentException {
        ArgumentAssert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static <X extends Throwable> void isFalse(boolean expression, Supplier<X> errorSupplier) throws X {
        if (expression) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws ArgumentException {
        ArgumentAssert.isFalse(expression, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static void isFalse(boolean expression) throws ArgumentException {
        ArgumentAssert.isFalse(expression, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    public static <X extends Throwable> void isNull(Object object, Supplier<X> errorSupplier) throws X {
        if (null != object) {
            throw (Throwable)errorSupplier.get();
        }
    }

    public static void isNull(Object object, String errorMsgTemplate, Object ... params) throws ArgumentException {
        ArgumentAssert.isNull(object, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static void isNull(Object object) throws ArgumentException {
        ArgumentAssert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static <T, X extends Throwable> T notNull(T object, Supplier<X> errorSupplier) throws X {
        if (null == object) {
            throw (Throwable)errorSupplier.get();
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notNull(object, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T> T notNull(T object) throws ArgumentException {
        return ArgumentAssert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notEmpty(T text, Supplier<X> errorSupplier) throws X {
        if (StrUtil.isEmpty(text)) {
            throw (Throwable)errorSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notEmpty(text, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T extends CharSequence> T notEmpty(T text) throws ArgumentException {
        return ArgumentAssert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notBlank(T text, Supplier<X> errorMsgSupplier) throws X {
        if (StrUtil.isBlank(text)) {
            throw (Throwable)errorMsgSupplier.get();
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notBlank(text, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T extends CharSequence> T notBlank(T text) throws ArgumentException {
        return ArgumentAssert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static <T extends CharSequence, X extends Throwable> T notContain(CharSequence textToSearch, T substring, Supplier<X> errorSupplier) throws X {
        if (StrUtil.contains((CharSequence)textToSearch, substring)) {
            throw (Throwable)errorSupplier.get();
        }
        return substring;
    }

    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notContain(textToSearch, substring, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static String notContain(String textToSearch, String substring) throws ArgumentException {
        return ArgumentAssert.notContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [{}]", substring);
    }

    public static <T> T contain(Collection<T> collection, T item) throws ArgumentException {
        return ArgumentAssert.contain(collection, item, "[\u65ad\u8a00\u5931\u8d25] - \u6b64\u96c6\u5408\u4e2d\u53c2\u6570\u4e0d\u5f97\u5305\u542b\u8be5\u503c [{}]", item);
    }

    public static <T> T contain(Collection<T> collection, T item, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.contain(collection, item, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T, X extends Throwable> T contain(Collection<T> collection, T item, Supplier<X> errorSupplier) throws X {
        if (!CollUtil.contains(collection, item)) {
            throw (Throwable)errorSupplier.get();
        }
        return item;
    }

    public static <T> T notContain(Collection<T> collection, T item) throws ArgumentException {
        return ArgumentAssert.notContain(collection, item, "[\u65ad\u8a00\u5931\u8d25] - \u6b64\u96c6\u5408\u4e2d\u53c2\u6570\u4e0d\u5f97\u5305\u542b\u8be5\u503c [{}]", item);
    }

    public static <T> T notContain(Collection<T> collection, T item, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notContain(collection, item, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T, X extends Throwable> T notContain(Collection<T> collection, T item, Supplier<X> errorSupplier) throws X {
        if (CollUtil.contains(collection, item)) {
            throw (Throwable)errorSupplier.get();
        }
        return item;
    }

    public static <T, X extends Throwable> T[] notEmpty(T[] array, Supplier<X> errorSupplier) throws X {
        if (ArrayUtil.isEmpty((Object[])array)) {
            throw (Throwable)errorSupplier.get();
        }
        return array;
    }

    public static <T> T[] notEmpty(T[] array, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notEmpty(array, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T> T[] notEmpty(T[] array) throws ArgumentException {
        return ArgumentAssert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <T, X extends Throwable> T[] noNullElements(T[] array, Supplier<X> errorSupplier) throws X {
        if (ArrayUtil.hasNull((Object[])array)) {
            throw (Throwable)errorSupplier.get();
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.noNullElements(array, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <T> T[] noNullElements(T[] array) throws ArgumentException {
        return ArgumentAssert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static <E, T extends Iterable<E>, X extends Throwable> T notEmpty(T collection, Supplier<X> errorSupplier) throws X {
        if (CollUtil.isEmpty(collection)) {
            throw (Throwable)errorSupplier.get();
        }
        return collection;
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notEmpty(collection, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <E, T extends Iterable<E>> T notEmpty(T collection) throws ArgumentException {
        return ArgumentAssert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <K, V, T extends Map<K, V>, X extends Throwable> T notEmpty(T map, Supplier<X> errorSupplier) throws X {
        if (MapUtil.isEmpty(map)) {
            throw (Throwable)errorSupplier.get();
        }
        return map;
    }

    public static <K, V, T extends Map<K, V>> T notEmpty(T map, String errorMsgTemplate, Object ... params) throws ArgumentException {
        return ArgumentAssert.notEmpty(map, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <K, V, T extends Map<K, V>> T notEmpty(T map) throws ArgumentException {
        return ArgumentAssert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", new Object[0]);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj) {
        return ArgumentAssert.isInstanceOf(type, obj, "Object [{}] is not instanceof [{}]", obj, type);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws ArgumentException {
        ArgumentAssert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            throw new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
        return obj;
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) throws ArgumentException {
        ArgumentAssert.isAssignable(superType, subType, "{} is not assignable to {})", subType, superType);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) throws ArgumentException {
        ArgumentAssert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (subType == null || !superType.isAssignableFrom(subType)) {
            throw new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void state(boolean expression, Supplier<String> errorMsgSupplier) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void state(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        ArgumentAssert.state(expression, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    public static int checkIndex(int index, int size) throws ArgumentException, IndexOutOfBoundsException {
        return ArgumentAssert.checkIndex(index, size, "[Assertion failed]", new Object[0]);
    }

    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) throws ArgumentException, IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(ArgumentAssert.badIndexMsg(index, size, errorMsgTemplate, params));
        }
        return index;
    }

    public static int checkBetween(int value, int min, int max) {
        if (value < min || value > max) {
            throw new ArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static long checkBetween(long value, long min, long max) {
        if (value < min || value > max) {
            throw new ArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static double checkBetween(double value, double min, double max) {
        if (value < min || value > max) {
            throw new ArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static Number checkBetween(Number value, Number min, Number max) {
        ArgumentAssert.notNull(value);
        ArgumentAssert.notNull(min);
        ArgumentAssert.notNull(max);
        double valueDouble = value.doubleValue();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        if (valueDouble < minDouble || valueDouble > maxDouble) {
            throw new ArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", (Object[])new Object[]{min, max}));
        }
        return value;
    }

    public static void equals(Object expected, Object actual, String errorMsgTemplate, Object ... params) {
        ArgumentAssert.equals(expected, actual, () -> new ArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params)));
    }

    public static <X extends Throwable> void equals(Object expected, Object actual, Supplier<? extends X> supplier) throws X {
        if (!ObjectUtil.equals((Object)expected, (Object)actual)) {
            throw (Throwable)supplier.get();
        }
    }

    private static String badIndexMsg(int index, int size, String desc, Object ... params) {
        if (index < 0) {
            return StrUtil.format((CharSequence)"{} ({}) must not be negative", (Object[])new Object[]{StrUtil.format((CharSequence)desc, (Object[])params), index});
        }
        if (size < 0) {
            throw new ArgumentException("negative size: " + size);
        }
        return StrUtil.format((CharSequence)"{} ({}) must be less than size ({})", (Object[])new Object[]{StrUtil.format((CharSequence)desc, (Object[])params), index, size});
    }
}

