/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cloud.http;

import cn.hutool.core.util.ObjectUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.tangyh.basic.context.ContextUtil;

public class RestTemplateHeaderInterceptor
implements ClientHttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestTemplateHeaderInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] bytes, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders httpHeaders = request.getHeaders();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            Map localMap = ContextUtil.getLocalMap();
            localMap.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            return execution.execute(request, bytes);
        }
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (httpServletRequest == null) {
            log.warn("path={}, \u5728FeignClient API\u63a5\u53e3\u672a\u914d\u7f6eFeignConfiguration\u7c7b\uff0c \u6545\u800c\u65e0\u6cd5\u5728\u8fdc\u7a0b\u8c03\u7528\u65f6\u83b7\u53d6\u8bf7\u6c42\u5934\u4e2d\u7684\u53c2\u6570!", (Object)request.getURI());
            return execution.execute(request, bytes);
        }
        HttpHeaders headers = request.getHeaders();
        headers.forEach((key, values) -> {
            String value = httpServletRequest.getHeader(key);
            value = ObjectUtil.isEmpty((Object)value) ? ContextUtil.get((String)key) : value;
            httpHeaders.add(key, value);
        });
        return execution.execute(request, bytes);
    }

    @Generated
    public RestTemplateHeaderInterceptor() {
    }
}

