/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cloud.rule;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.nacos.NacosServiceInstance;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;
import top.tangyh.basic.context.ContextUtil;

public class GrayscaleVersionRoundRobinLoadBalancer
extends RoundRobinLoadBalancer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrayscaleVersionRoundRobinLoadBalancer.class);
    private ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private String serviceId;

    public GrayscaleVersionRoundRobinLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId) {
        super(serviceInstanceListSupplierProvider, serviceId);
        this.serviceId = serviceId;
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
    }

    public GrayscaleVersionRoundRobinLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, String serviceId, int seedPosition) {
        super(serviceInstanceListSupplierProvider, serviceId, seedPosition);
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> this.getInstanceResponse((List<ServiceInstance>)serviceInstances, request));
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances, Request request) {
        if (CollUtil.isEmpty(instances)) {
            log.warn("\u6ce8\u518c\u4e2d\u5fc3\u65e0\u53ef\u7528\u5b9e\u4f8b {}", (Object)this.serviceId);
            return new EmptyResponse();
        }
        String grayVersion = ContextUtil.getGrayVersion();
        if (StrUtil.isBlank((CharSequence)grayVersion)) {
            return (Response)super.choose(request).block();
        }
        for (ServiceInstance instance : instances) {
            NacosServiceInstance nacosInstance = (NacosServiceInstance)instance;
            Map metadata = nacosInstance.getMetadata();
            if (!grayVersion.equalsIgnoreCase((String)metadata.get("gray_version"))) continue;
            log.debug("\u7070\u5ea6 \u5339\u914d\u6210\u529f\uff0c \u53c2\u6570\uff1a{} \u5b9e\u4f8b\uff1a{}", (Object)grayVersion, (Object)nacosInstance);
            return new DefaultResponse((ServiceInstance)nacosInstance);
        }
        return (Response)super.choose(request).block();
    }
}

