/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto.storage;

import java.io.IOException;
import java.io.InputStream;

public class FdfsInputStream
extends InputStream {
    private final InputStream ins;
    private final long size;
    private long remainByteSize;

    public FdfsInputStream(InputStream ins, long size) {
        this.ins = ins;
        this.size = size;
        this.remainByteSize = size;
    }

    @Override
    public int read() throws IOException {
        return this.ins.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remainByteSize == 0L) {
            return -1;
        }
        int byteSize = this.ins.read(b, off, len);
        if (this.remainByteSize < (long)byteSize) {
            throw new IOException("\u534f\u8bae\u957f\u5ea6" + this.size + "\u4e0e\u5b9e\u9645\u957f\u5ea6\u4e0d\u7b26");
        }
        this.remainByteSize -= (long)byteSize;
        return byteSize;
    }

    @Override
    public void close() throws IOException {
    }

    public boolean isReadCompleted() {
        return this.remainByteSize == 0L;
    }
}

