/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.writer;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import top.redscorpion.core.comparator.IndexedComparator;
import top.redscorpion.core.map.TableMap;
import top.redscorpion.core.map.multi.RowKeyTable;
import top.redscorpion.core.map.multi.Table;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.ExcelConfig;

public class ExcelWriteConfig
extends ExcelConfig {
    protected boolean onlyAlias;
    protected boolean insertRow = true;
    protected Comparator<String> aliasComparator;

    @Override
    public ExcelWriteConfig setHeaderAlias(Map<String, String> headerAlias) {
        this.aliasComparator = null;
        return (ExcelWriteConfig)super.setHeaderAlias(headerAlias);
    }

    @Override
    public ExcelWriteConfig addHeaderAlias(String header, String alias) {
        this.aliasComparator = null;
        return (ExcelWriteConfig)super.addHeaderAlias(header, alias);
    }

    @Override
    public ExcelWriteConfig removeHeaderAlias(String header) {
        this.aliasComparator = null;
        return (ExcelWriteConfig)super.removeHeaderAlias(header);
    }

    public ExcelWriteConfig setOnlyAlias(boolean isOnlyAlias) {
        this.onlyAlias = isOnlyAlias;
        return this;
    }

    public ExcelWriteConfig setInsertRow(boolean insertRow) {
        this.insertRow = insertRow;
        return this;
    }

    public Comparator<String> getCachedAliasComparator() {
        Map headerAlias = this.headerAlias;
        if (RsMap.isEmpty(headerAlias)) {
            return null;
        }
        Comparator<String> aliasComparator = this.aliasComparator;
        if (null == aliasComparator) {
            Set keySet = headerAlias.keySet();
            this.aliasComparator = aliasComparator = new IndexedComparator<String>(keySet.toArray(new String[0]));
        }
        return aliasComparator;
    }

    public Table<?, ?, ?> aliasTable(Map<?, ?> rowMap) {
        RowKeyTable filteredTable = new RowKeyTable(new LinkedHashMap(), TableMap::new);
        if (RsMap.isEmpty(this.headerAlias)) {
            rowMap.forEach((key, value) -> filteredTable.put(key, key, value));
        } else {
            rowMap.forEach((key, value) -> {
                String aliasName = (String)this.headerAlias.get(RsString.toString(key));
                if (null != aliasName) {
                    filteredTable.put(key, aliasName, value);
                } else if (!this.onlyAlias) {
                    filteredTable.put(key, key, value);
                }
            });
        }
        return filteredTable;
    }
}

