/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.sax;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.cell.values.FormulaCellValue;
import top.redscorpion.poi.excel.sax.AttributeName;
import top.redscorpion.poi.excel.sax.CellDataType;
import top.redscorpion.poi.excel.sax.ElementName;
import top.redscorpion.poi.excel.sax.RsExcelSax;
import top.redscorpion.poi.excel.sax.handler.RowHandler;

public class SheetDataSaxHandler
extends DefaultHandler {
    protected RowHandler rowHandler;
    private final boolean padCellAtEndOfRow;
    protected StylesTable stylesTable;
    protected SharedStrings sharedStrings;
    protected int sheetIndex;
    protected int index;
    private int curCell;
    private CellDataType cellDataType;
    private long rowNumber;
    private String curCoordinate;
    private ElementName curElementName;
    private String preCoordinate;
    private String maxCellCoordinate;
    private XSSFCellStyle xssfCellStyle;
    private String numFmtString;
    private boolean isInSheetData;
    private final StringBuilder lastContent = new StringBuilder();
    private final StringBuilder lastFormula = new StringBuilder();
    private List<Object> rowCellList = new ArrayList<Object>();

    public SheetDataSaxHandler(RowHandler rowHandler, boolean padCellAtEndOfRow) {
        this.rowHandler = rowHandler;
        this.padCellAtEndOfRow = padCellAtEndOfRow;
    }

    public void setRowHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        ElementName name;
        if ("sheetData".equals(qName)) {
            this.isInSheetData = true;
            return;
        }
        if (!this.isInSheetData) {
            return;
        }
        this.curElementName = name = ElementName.of(qName);
        if (null != name) {
            switch (name) {
                case row: {
                    this.startRow(attributes);
                    break;
                }
                case c: {
                    this.startCell(attributes);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("sheetData".equals(qName)) {
            this.isInSheetData = false;
            return;
        }
        if (!this.isInSheetData) {
            return;
        }
        this.curElementName = null;
        if (ElementName.c.match(qName)) {
            this.endCell();
        } else if (ElementName.row.match(qName)) {
            this.endRow();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.isInSheetData) {
            return;
        }
        ElementName elementName = this.curElementName;
        if (null != elementName) {
            switch (elementName) {
                case v: {
                    this.lastContent.append(ch, start, length);
                    break;
                }
                case f: {
                    this.lastFormula.append(ch, start, length);
                }
            }
        } else {
            this.lastContent.append(ch, start, length);
        }
    }

    private void startRow(Attributes attributes) {
        String rValue = AttributeName.r.getValue(attributes);
        this.rowNumber = null == rValue ? -1L : Long.parseLong(rValue) - 1L;
    }

    private void startCell(Attributes attributes) {
        String tempCurCoordinate = AttributeName.r.getValue(attributes);
        this.preCoordinate = this.preCoordinate == null ? String.valueOf('@') : this.curCoordinate;
        this.curCoordinate = tempCurCoordinate;
        this.setCellType(attributes);
        this.lastContent.setLength(0);
        this.lastFormula.setLength(0);
    }

    private void endRow() {
        if (this.index == 0) {
            this.maxCellCoordinate = this.curCoordinate;
        }
        if (this.padCellAtEndOfRow && this.maxCellCoordinate != null) {
            this.padCell(this.curCoordinate, this.maxCellCoordinate, true);
        }
        this.rowHandler.handle(this.sheetIndex, this.rowNumber, this.rowCellList);
        this.rowCellList = new ArrayList<Object>(this.curCell + 1);
        ++this.index;
        this.curCell = 0;
        this.curCoordinate = null;
        this.preCoordinate = null;
    }

    private void endCell() {
        Object value;
        this.padCell(this.preCoordinate, this.curCoordinate, false);
        String contentStr = RsString.trim(this.lastContent);
        if (this.lastFormula.length() > 0) {
            if (CellDataType.NULL == this.cellDataType) {
                this.cellDataType = CellDataType.NUMBER;
            }
            value = new FormulaCellValue(RsString.trim(this.lastFormula), RsExcelSax.getDataValue(this.cellDataType, contentStr, this.sharedStrings, this.numFmtString));
        } else {
            value = RsExcelSax.getDataValue(this.cellDataType, contentStr, this.sharedStrings, this.numFmtString);
        }
        this.addCellValue(this.curCell++, value);
    }

    private void addCellValue(int index, Object value) {
        this.rowCellList.add(index, value);
        this.rowHandler.handleCell(this.sheetIndex, this.rowNumber, index, value, (CellStyle)this.xssfCellStyle);
    }

    private void padCell(String preCoordinate, String curCoordinate, boolean isEnd) {
        if (!curCoordinate.equals(preCoordinate)) {
            int len = RsExcelSax.countNullCell(preCoordinate, curCoordinate);
            if (isEnd) {
                // empty if block
            }
            while (true) {
                int n = ++len;
                --len;
                if (n <= 0) break;
                this.addCellValue(this.curCell++, null);
            }
        }
    }

    private void setCellType(Attributes attributes) {
        String xfIndexStr;
        this.numFmtString = "";
        this.cellDataType = CellDataType.of(AttributeName.t.getValue(attributes));
        if (null != this.stylesTable && null != (xfIndexStr = AttributeName.s.getValue(attributes))) {
            this.xssfCellStyle = this.stylesTable.getStyleAt(Integer.parseInt(xfIndexStr));
            short numFmtIndex = this.xssfCellStyle.getDataFormat();
            this.numFmtString = RsObject.defaultIfNull(this.xssfCellStyle.getDataFormatString(), () -> BuiltinFormats.getBuiltinFormat((int)numFmtIndex));
            if ((CellDataType.NUMBER == this.cellDataType || CellDataType.NULL == this.cellDataType) && RsExcelSax.isDateFormat(numFmtIndex, this.numFmtString)) {
                this.cellDataType = CellDataType.DATE;
            }
        }
    }
}

