/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.cell.setters;

import java.io.File;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.poi.excel.SimpleClientAnchor;
import top.redscorpion.poi.excel.cell.setters.CellSetter;
import top.redscorpion.poi.excel.shape.ExcelPicType;
import top.redscorpion.poi.excel.shape.RsExcelPic;
import top.redscorpion.poi.excel.writer.RsExcelDrawing;

public class PicCellSetter
implements CellSetter {
    private final byte[] pictureData;
    private final ExcelPicType picType;

    public PicCellSetter(byte[] pictureData) {
        this(pictureData, ExcelPicType.PNG);
    }

    public PicCellSetter(File picturefile) {
        this(RsFile.readBytes(picturefile), RsExcelPic.getPicType(picturefile));
    }

    public PicCellSetter(byte[] pictureData, ExcelPicType picType) {
        this.pictureData = pictureData;
        this.picType = picType;
    }

    @Override
    public void setValue(Cell cell) {
        Sheet sheet = cell.getSheet();
        int columnIndex = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        RsExcelDrawing.drawingPic(sheet, this.pictureData, this.picType, new SimpleClientAnchor(columnIndex, rowIndex, columnIndex + 1, rowIndex + 1));
    }
}

