/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import top.redscorpion.core.util.RsColl;

public class RowGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private CellStyle style;
    private List<RowGroup> children;

    public static RowGroup of(String name) {
        return new RowGroup(name);
    }

    public RowGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RowGroup setName(String name) {
        this.name = name;
        return this;
    }

    public CellStyle getStyle() {
        return this.style;
    }

    public RowGroup setStyle(CellStyle style) {
        this.style = style;
        return this;
    }

    public List<RowGroup> getChildren() {
        return this.children;
    }

    public RowGroup setChildren(List<RowGroup> children) {
        this.children = children;
        return this;
    }

    public RowGroup addChild(String name) {
        return this.addChild(RowGroup.of(name));
    }

    public RowGroup addChild(RowGroup child) {
        if (null == this.children) {
            this.children = new LinkedList<RowGroup>();
        }
        this.children.add(child);
        return this;
    }

    public int maxColumnCount() {
        if (RsColl.isEmpty(this.children)) {
            return 1;
        }
        return this.children.stream().mapToInt(RowGroup::maxColumnCount).sum();
    }

    public int maxRowCount() {
        int maxRowCount = this.childrenMaxRowCount();
        if (null != this.name) {
            ++maxRowCount;
        }
        if (0 == maxRowCount) {
            throw new IllegalArgumentException("Empty RowGroup!, please set the name or add children.");
        }
        return maxRowCount;
    }

    public int childrenMaxRowCount() {
        int maxRowCount = 0;
        if (null != this.children) {
            maxRowCount = this.children.stream().mapToInt(RowGroup::maxRowCount).max().orElse(0);
        }
        return maxRowCount;
    }
}

