/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.log.engine;

import java.net.URL;
import top.redscorpion.core.lang.Singleton;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsResource;
import top.redscorpion.core.util.RsSpi;
import top.redscorpion.log.AbstractLogFactory;
import top.redscorpion.log.engine.LogEngine;
import top.redscorpion.log.engine.console.ConsoleLogEngine;
import top.redscorpion.log.engine.jdk.JdkLogEngine;

public class LogEngineFactory {
    public static LogEngine getEngine() {
        return InstanceHolder.INSTANCE;
    }

    public static void setDefaultEngine(Class<? extends LogEngine> logEngineClass) {
        try {
            LogEngineFactory.setDefaultEngine(RsConstructor.newInstance(logEngineClass, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not instance LogFactory class!", e);
        }
    }

    public static void setDefaultEngine(LogEngine logEngine) {
        Singleton.put(LogEngineFactory.class.getName(), logEngine);
        logEngine.createLog(LogEngineFactory.class).debug("Custom Use [{}] Logger.", logEngine.getName());
    }

    public static LogEngine createEngine() {
        LogEngine engine = LogEngineFactory.doCreateEngine();
        engine.createLog(AbstractLogFactory.class).debug("Use [{}] Logger As Default.", engine.getName());
        return engine;
    }

    private static LogEngine doCreateEngine() {
        LogEngine engine = RsSpi.loadFirstAvailable(LogEngine.class);
        if (null != engine) {
            return engine;
        }
        URL url = RsResource.getResourceUrl("logging.properties");
        return null != url ? new JdkLogEngine() : new ConsoleLogEngine();
    }

    private static class InstanceHolder {
        public static final LogEngine INSTANCE = LogEngineFactory.createEngine();

        private InstanceHolder() {
        }
    }
}

