/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.ssl;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import top.redscorpion.core.net.ssl.RsSSLContext;
import top.redscorpion.core.net.ssl.TrustAnyHostnameVerifier;
import top.redscorpion.core.net.ssl.TrustAnyTrustManager;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.ssl.CustomProtocolsSSLFactory;

public class SSLInfo {
    public static final SSLInfo DEFAULT = SSLInfo.of().setSslContext(RsSSLContext.getDefault());
    public static final SSLInfo TRUST_ANY = SSLInfo.of().setHostnameVerifier(TrustAnyHostnameVerifier.INSTANCE).setSslContext(RsSSLContext.createTrustAnySSLContext()).setTrustManager(TrustAnyTrustManager.INSTANCE);
    private String[] protocols;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;
    private X509TrustManager trustManager;

    public static SSLInfo of() {
        return new SSLInfo();
    }

    public SSLInfo() {
        if (RsString.equalsIgnoreCase("dalvik", System.getProperty("java.vm.name"))) {
            this.protocols = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
        }
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public SSLInfo setProtocols(String ... protocols) {
        this.protocols = protocols;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public SSLInfo setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public SSLInfo setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public SSLInfo setTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public SSLSocketFactory getSocketFactory() {
        if (null == this.sslContext) {
            return null;
        }
        SSLSocketFactory factory = this.sslContext.getSocketFactory();
        return new CustomProtocolsSSLFactory(factory, this.protocols);
    }
}

