/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.okhttp;

import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.engine.EngineRequestBuilder;
import top.redscorpion.http.client.engine.okhttp.OkHttpRequestBody;

public class OkHttpRequestBuilder
implements EngineRequestBuilder<okhttp3.Request> {
    public static final OkHttpRequestBuilder INSTANCE = new OkHttpRequestBuilder();

    @Override
    public okhttp3.Request build(Request message) {
        Request.Builder builder = new Request.Builder().url(message.handledUrl().toUrl());
        String method = message.method().name();
        HttpBody body = message.handledBody();
        if (null != body || HttpMethod.requiresRequestBody((String)method)) {
            builder.method(method, (RequestBody)new OkHttpRequestBody(body));
        } else {
            builder.method(method, null);
        }
        message.headers().forEach((key, values) -> values.forEach(value -> builder.addHeader(key, value)));
        return builder.build();
    }
}

