/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.okhttp;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.RequestContext;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.cookie.InMemoryCookieStore;
import top.redscorpion.http.client.engine.AbstractClientEngine;
import top.redscorpion.http.client.engine.okhttp.BasicProxyAuthenticator;
import top.redscorpion.http.client.engine.okhttp.CookieJarImpl;
import top.redscorpion.http.client.engine.okhttp.OkHttpClientConfig;
import top.redscorpion.http.client.engine.okhttp.OkHttpRequestBuilder;
import top.redscorpion.http.client.engine.okhttp.OkHttpResponse;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.HttpStatus;
import top.redscorpion.http.meta.Method;
import top.redscorpion.http.proxy.ProxyInfo;
import top.redscorpion.http.ssl.SSLInfo;

public class OkHttpEngine
extends AbstractClientEngine {
    private OkHttpClient client;

    public OkHttpEngine() {
        Assert.notNull(OkHttpClient.class);
    }

    @Override
    public OkHttpEngine init(ClientConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public Response send(Request message) {
        this.initEngine();
        return this.doSend(new RequestContext(message));
    }

    @Override
    public Object getRawEngine() {
        return this.client;
    }

    @Override
    public void close() {
    }

    @Override
    protected void reset() {
        this.client = null;
    }

    @Override
    protected void initEngine() {
        long timeToLive;
        int readTimeout;
        int connectionTimeout;
        if (null != this.client) {
            return;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ClientConfig config = RsObject.defaultIfNull(this.config, ClientConfig::of);
        SSLInfo sslInfo = config.getSslInfo();
        if (null != sslInfo) {
            SSLSocketFactory socketFactory = sslInfo.getSocketFactory();
            X509TrustManager trustManager = sslInfo.getTrustManager();
            if (null != socketFactory && null != trustManager) {
                builder.sslSocketFactory(socketFactory, trustManager);
            }
        }
        if ((connectionTimeout = config.getConnectionTimeout()) > 0) {
            builder.connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = config.getReadTimeout()) > 0) {
            builder.readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS);
        }
        int maxIdle = 0;
        if (config instanceof OkHttpClientConfig) {
            maxIdle = ((OkHttpClientConfig)config).getMaxIdle();
        }
        if (maxIdle <= 0) {
            maxIdle = 5;
        }
        if ((timeToLive = config.getTimeToLive()) <= 0L) {
            timeToLive = TimeUnit.MINUTES.toMillis(5L);
        }
        builder.connectionPool(new ConnectionPool(maxIdle, timeToLive, TimeUnit.MILLISECONDS));
        builder.followRedirects(false);
        OkHttpEngine.setProxy(builder, config);
        if (null != this.config && this.config.isUseCookieManager()) {
            this.cookieStore = new InMemoryCookieStore();
            builder.cookieJar((CookieJar)new CookieJarImpl(this.cookieStore));
        }
        this.client = builder.build();
    }

    private Response doSend(RequestContext context) {
        okhttp3.Response response;
        Request message = context.getRequest();
        okhttp3.Request request = OkHttpRequestBuilder.INSTANCE.build(message);
        try {
            response = this.client.newCall(request).execute();
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        int maxRedirects = message.maxRedirects();
        if (maxRedirects > 0 && context.getRedirectCount() < maxRedirects) {
            int code = response.code();
            if (HttpStatus.isRedirected(code)) {
                message.locationTo(response.header(HeaderName.LOCATION.getValue()));
            }
            if (307 != code) {
                message.method(Method.GET);
            }
            context.incrementRedirectCount();
            return this.doSend(context);
        }
        return new OkHttpResponse(response, message);
    }

    private static void setProxy(OkHttpClient.Builder builder, ClientConfig config) {
        ProxyInfo proxyInfo = config.getProxy();
        if (null != proxyInfo) {
            PasswordAuthentication auth;
            ProxySelector proxySelector = proxyInfo.getProxySelector();
            if (null != proxySelector) {
                builder.proxySelector(proxySelector);
            }
            if (null != (auth = proxyInfo.getAuth())) {
                builder.proxyAuthenticator((Authenticator)new BasicProxyAuthenticator(auth));
            }
        }
    }
}

