/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.okhttp;

import java.util.ArrayList;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.http.client.cookie.CookieSpi;
import top.redscorpion.http.client.cookie.CookieStoreSpi;
import top.redscorpion.http.client.engine.okhttp.OkCookie;

public class CookieJarImpl
implements CookieJar {
    private final CookieStoreSpi cookieStore;

    public CookieJarImpl(CookieStoreSpi cookieStore) {
        this.cookieStore = cookieStore;
    }

    public CookieStoreSpi getCookieStore() {
        return this.cookieStore;
    }

    public List<Cookie> loadForRequest(HttpUrl httpUrl) {
        List<CookieSpi> cookieSpis = this.cookieStore.get(httpUrl.uri());
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieSpis.size());
        for (CookieSpi cookieSpi : cookieSpis) {
            cookies.add((Cookie)((OkCookie)cookieSpi).getRaw());
        }
        return cookies;
    }

    public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
        if (RsColl.isEmpty(list)) {
            return;
        }
        for (Cookie cookie : list) {
            this.cookieStore.add(httpUrl.uri(), new OkCookie(cookie));
        }
    }
}

