/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.jdk;

import java.io.IOException;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.RequestContext;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.cookie.InMemoryCookieStore;
import top.redscorpion.http.client.engine.AbstractClientEngine;
import top.redscorpion.http.client.engine.jdk.JdkCookieManager;
import top.redscorpion.http.client.engine.jdk.JdkHttpConnection;
import top.redscorpion.http.client.engine.jdk.JdkHttpResponse;
import top.redscorpion.http.client.engine.jdk.JdkRequestBuilder;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.HttpStatus;
import top.redscorpion.http.meta.Method;

public class JdkClientEngine
extends AbstractClientEngine {
    private JdkCookieManager cookieManager;

    public JdkCookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Override
    public JdkHttpResponse send(Request message) {
        this.initEngine();
        return this.doSend(new RequestContext(message));
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
        this.cookieManager = null;
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void initEngine() {
        if (null != this.cookieManager) {
            return;
        }
        if (null != this.config && this.config.isUseCookieManager()) {
            this.cookieStore = new InMemoryCookieStore();
            this.cookieManager = new JdkCookieManager(this.cookieStore);
        }
    }

    private JdkHttpResponse doSend(RequestContext context) {
        Request message = context.getRequest();
        JdkHttpConnection conn = new JdkRequestBuilder(this.config, this.cookieManager).build(message);
        try {
            this.doSend(conn, message);
        }
        catch (IOException e) {
            RsIo.closeQuietly(conn);
            throw new HttpException(e);
        }
        int maxRedirects = message.maxRedirects();
        if (maxRedirects > 0 && context.getRedirectCount() < maxRedirects) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.closeQuietly();
                throw new HttpException(e);
            }
            if (HttpStatus.isRedirected(code)) {
                if (307 != code) {
                    message.method(Method.GET);
                }
                message.locationTo(conn.header(HeaderName.LOCATION));
                context.incrementRedirectCount();
                return this.doSend(context);
            }
        }
        return new JdkHttpResponse(conn, this.cookieManager, context.getRequest());
    }

    private void doSend(JdkHttpConnection conn, Request message) throws IOException {
        HttpBody body = message.handledBody();
        if (null != body) {
            body.writeClose(conn.getOutputStream());
            return;
        }
        conn.connect();
    }
}

