/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.httpclient5;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.wrapper.SimpleWrapper;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.ResponseBody;

public class HttpClient5Response
extends SimpleWrapper<ClassicHttpResponse>
implements Response {
    private final HttpEntity entity;
    private final Charset requestCharset;
    private final ResponseBody body;

    public HttpClient5Response(ClassicHttpResponse rawRes, Request message) {
        super(rawRes);
        this.entity = rawRes.getEntity();
        this.requestCharset = message.charset();
        this.body = message.method().isIgnoreBody() ? null : new ResponseBody(this, this.bodyStream());
    }

    @Override
    public int getStatus() {
        return ((ClassicHttpResponse)this.raw).getCode();
    }

    @Override
    public String header(String name) {
        Header[] headers = ((ClassicHttpResponse)this.raw).getHeaders(name);
        if (RsArray.isNotEmpty(headers)) {
            return headers[0].getValue();
        }
        return null;
    }

    @Override
    public Map<String, List<String>> headers() {
        Header[] headers = ((ClassicHttpResponse)this.raw).getHeaders();
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(headers.length, 1.0f);
        for (Header header : headers) {
            List valueList = result.computeIfAbsent(header.getName(), k -> new ArrayList());
            valueList.add(header.getValue());
        }
        return result;
    }

    @Override
    public long contentLength() {
        return null == this.entity ? -1L : this.entity.getContentLength();
    }

    @Override
    public Charset charset() {
        return RsObject.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        if (null == this.entity) {
            return null;
        }
        try {
            return this.entity.getContent();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public HttpClient5Response sync() {
        ResponseBody body = this.body;
        if (null != body) {
            body.sync();
        }
        RsIo.closeQuietly((AutoCloseable)this.raw);
        return this;
    }

    @Override
    public ResponseBody body() {
        return this.body;
    }

    @Override
    public String bodyStr() throws HttpException {
        if (null == this.entity) {
            return null;
        }
        try {
            return EntityUtils.toString((HttpEntity)this.entity, (Charset)this.charset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ParseException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public void close() throws IOException {
        ((ClassicHttpResponse)this.raw).close();
    }

    public String toString() {
        return RsHttp.toString(this);
    }
}

