/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.httpclient4;

import java.io.Closeable;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeader;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.GlobalHeaders;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.ApacheHttpClientConfig;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.cookie.InMemoryCookieStore;
import top.redscorpion.http.client.engine.AbstractClientEngine;
import top.redscorpion.http.client.engine.httpclient4.ConnectionSocketFactoryRegistryBuilder;
import top.redscorpion.http.client.engine.httpclient4.HttpClient4CookieStore;
import top.redscorpion.http.client.engine.httpclient4.HttpClient4Response;
import top.redscorpion.http.client.engine.httpclient4.HttpUriRequestBuilder;
import top.redscorpion.http.proxy.ProxyInfo;

public class HttpClient4Engine
extends AbstractClientEngine {
    private CloseableHttpClient engine;

    public HttpClient4Engine() {
        Assert.notNull(CloseableHttpClient.class);
    }

    @Override
    public Response send(Request message) {
        CloseableHttpResponse response;
        this.initEngine();
        HttpUriRequest request = HttpUriRequestBuilder.INSTANCE.build(message);
        try {
            response = this.engine.execute(request);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        return new HttpClient4Response((HttpResponse)response, message);
    }

    @Override
    public Object getRawEngine() {
        return this.engine;
    }

    @Override
    public void close() throws IOException {
        RsIo.nullSafeClose((Closeable)this.engine);
    }

    @Override
    protected void reset() {
        RsIo.closeQuietly(new AutoCloseable[]{this.engine});
        this.engine = null;
    }

    @Override
    protected void initEngine() {
        if (null != this.engine) {
            return;
        }
        HttpClientBuilder clientBuilder = HttpClients.custom();
        ClientConfig config = RsObject.defaultIfNull(this.config, ApacheHttpClientConfig::of);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)this.buildConnectionManager(config));
        clientBuilder.setDefaultRequestConfig(HttpClient4Engine.buildDefaultRequestConfig(config));
        if (config.isDisableCache()) {
            clientBuilder.disableAuthCaching();
        }
        clientBuilder.setDefaultHeaders(HttpClient4Engine.toHeaderList(GlobalHeaders.INSTANCE.headers()));
        HttpClient4Engine.setProxy(clientBuilder, config);
        if (config.isUseCookieManager()) {
            this.cookieStore = new InMemoryCookieStore();
            clientBuilder.setDefaultCookieStore((CookieStore)new HttpClient4CookieStore(this.cookieStore));
        }
        this.engine = clientBuilder.build();
    }

    private static List<Header> toHeaderList(Map<String, ? extends Collection<String>> headersMap) {
        ArrayList<Header> result = new ArrayList<Header>();
        headersMap.forEach((k, v1) -> v1.forEach(v2 -> result.add((Header)new BasicHeader(k, v2))));
        return result;
    }

    private PoolingHttpClientConnectionManager buildConnectionManager(ClientConfig config) {
        long timeToLive = config.getTimeToLive();
        if (timeToLive <= 0L) {
            timeToLive = -1L;
        }
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(ConnectionSocketFactoryRegistryBuilder.build(config.getSslInfo()), null, null, null, timeToLive, TimeUnit.MILLISECONDS);
        if (config instanceof ApacheHttpClientConfig) {
            int maxPerRoute;
            ApacheHttpClientConfig apacheHttpClientConfig = (ApacheHttpClientConfig)config;
            int maxTotal = apacheHttpClientConfig.getMaxTotal();
            if (maxTotal > 0) {
                manager.setMaxTotal(maxTotal);
            }
            if ((maxPerRoute = apacheHttpClientConfig.getMaxPerRoute()) > 0) {
                manager.setDefaultMaxPerRoute(maxPerRoute);
            }
        }
        return manager;
    }

    private static RequestConfig buildDefaultRequestConfig(ClientConfig config) {
        int readTimeout;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        int connectionTimeout = config.getConnectionTimeout();
        if (connectionTimeout > 0) {
            requestConfigBuilder.setConnectTimeout(connectionTimeout);
            requestConfigBuilder.setConnectionRequestTimeout(connectionTimeout);
        }
        if ((readTimeout = config.getReadTimeout()) > 0) {
            requestConfigBuilder.setSocketTimeout(readTimeout);
        }
        return requestConfigBuilder.build();
    }

    private static void setProxy(HttpClientBuilder clientBuilder, ClientConfig config) {
        if (null == config) {
            return;
        }
        ProxyInfo proxy = config.getProxy();
        if (null != proxy) {
            PasswordAuthentication auth;
            ProxySelector proxySelector = proxy.getProxySelector();
            if (null != proxySelector) {
                clientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(proxySelector));
            }
            if (null != (auth = proxy.getAuth())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(new HttpHost(proxy.getAuthHost(), proxy.getAuthPort())), (Credentials)new UsernamePasswordCredentials(auth.getUserName(), String.valueOf(auth.getPassword())));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
    }
}

