/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.cookie;

import java.net.URI;
import java.util.List;
import top.redscorpion.http.client.cookie.CookieSpi;
import top.redscorpion.http.client.cookie.CookieStoreSpi;
import top.redscorpion.http.client.cookie.InMemoryCookieStore;

public class ThreadLocalCookieStore
implements CookieStoreSpi {
    private static final ThreadLocal<CookieStoreSpi> STORES = new ThreadLocal<CookieStoreSpi>(){

        @Override
        protected synchronized CookieStoreSpi initialValue() {
            return new InMemoryCookieStore();
        }
    };

    public CookieStoreSpi getCookieStore() {
        return STORES.get();
    }

    public ThreadLocalCookieStore removeCurrent() {
        STORES.remove();
        return this;
    }

    @Override
    public List<URI> getURIs() {
        return this.getCookieStore().getURIs();
    }

    @Override
    public void add(URI httpUrl, CookieSpi cookie) {
        this.getCookieStore().add(httpUrl, cookie);
    }

    @Override
    public List<CookieSpi> get(URI httpUrl) {
        return this.getCookieStore().get(httpUrl);
    }

    @Override
    public List<CookieSpi> getCookies() {
        return this.getCookieStore().getCookies();
    }

    @Override
    public boolean remove(URI httpUrl, CookieSpi cookie) {
        return this.getCookieStore().remove(httpUrl, cookie);
    }

    @Override
    public boolean clear() {
        return this.getCookieStore().clear();
    }
}

