/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.body;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import top.redscorpion.core.io.StreamProgress;
import top.redscorpion.core.io.stream.SyncInputStream;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsFileName;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.HttpGlobalConfig;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.html.RsHtml;
import top.redscorpion.http.meta.HeaderName;

public class ResponseBody
implements HttpBody,
Closeable {
    private final Response response;
    private final SyncInputStream bodyStream;

    public ResponseBody(Response response, InputStream in) {
        this(response, in, true, true);
    }

    public ResponseBody(Response response, InputStream in, boolean isAsync, boolean isIgnoreEOFError) {
        this.response = response;
        this.bodyStream = new SyncInputStream(in, response.contentLength(), isAsync, isIgnoreEOFError);
    }

    @Override
    public String contentType() {
        return this.response.header(HeaderName.CONTENT_TYPE);
    }

    @Override
    public long contentLength() {
        return this.response.contentLength();
    }

    @Override
    public InputStream getStream() {
        return this.bodyStream;
    }

    @Override
    public void write(OutputStream out) {
        this.write(out, false, null);
    }

    public ResponseBody sync() {
        this.bodyStream.sync();
        return this;
    }

    @Override
    public byte[] getBytes() {
        this.sync();
        return this.bodyStream.readBytes();
    }

    public String getString() {
        return RsHtml.getString(this.getBytes(), this.response.charset(), HttpGlobalConfig.isGetCharsetFromContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        long l;
        block3: {
            Assert.notNull(out, "[out] must be not null!", new Object[0]);
            try {
                l = this.bodyStream.copyTo(out, streamProgress);
                if (!isCloseOut) break block3;
            }
            catch (Throwable throwable) {
                if (isCloseOut) {
                    RsIo.closeQuietly(out);
                }
                throw throwable;
            }
            RsIo.closeQuietly(out);
        }
        return l;
    }

    public File write(String targetFileOrDir) {
        return this.write(RsFile.file(targetFileOrDir));
    }

    public File write(File targetFileOrDir) {
        return this.write(targetFileOrDir, null);
    }

    public File write(File targetFileOrDir, StreamProgress streamProgress) {
        return this.write(targetFileOrDir, null, streamProgress);
    }

    public File write(File targetFileOrDir, String tempFileSuffix, StreamProgress streamProgress) {
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.getTargetFile(targetFileOrDir, null);
        String fileName = outFile.getName();
        outFile = new File(outFile.getParentFile(), RsFileName.addTempSuffix(fileName, tempFileSuffix));
        try {
            outFile = this.writeDirect(outFile, null, streamProgress);
            return RsFile.rename(outFile, fileName, true);
        }
        catch (Throwable e) {
            RsFile.del(outFile);
            throw new HttpException(e);
        }
    }

    public File writeDirect(File targetFileOrDir, String customParamName, StreamProgress streamProgress) {
        Assert.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.getTargetFile(targetFileOrDir, customParamName);
        this.write(RsFile.getOutputStream(outFile, new OpenOption[0]), true, streamProgress);
        return outFile;
    }

    @Override
    public void close() throws IOException {
        this.bodyStream.close();
    }

    public String toString() {
        return this.getString();
    }

    private File getTargetFile(File targetFileOrDir, String customParamName) {
        if (!targetFileOrDir.isDirectory()) {
            return targetFileOrDir;
        }
        String fileName = this.response.getFileNameFromDisposition(customParamName);
        if (RsString.isBlank(fileName)) {
            throw new HttpException("Can`t get file name from [Content-Disposition]!");
        }
        return RsFile.file(targetFileOrDir, fileName);
    }
}

