/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.body;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.resource.BytesResource;
import top.redscorpion.core.io.resource.FileResource;
import top.redscorpion.core.io.resource.HttpResource;
import top.redscorpion.core.io.resource.InputStreamResource;
import top.redscorpion.core.io.resource.MultiResource;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.io.resource.StringResource;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.HttpGlobalConfig;
import top.redscorpion.http.meta.ContentType;

public class MultipartOutputStream
extends OutputStream {
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n";
    private final OutputStream out;
    private final Charset charset;
    private final String boundary;
    private boolean isFinish;

    public MultipartOutputStream(OutputStream out, Charset charset) {
        this(out, charset, HttpGlobalConfig.getBoundary());
    }

    public MultipartOutputStream(OutputStream out, Charset charset, String boundary) {
        this.out = out;
        this.charset = charset;
        this.boundary = boundary;
    }

    public MultipartOutputStream write(String formFieldName, Object value) throws IORuntimeException {
        if (value instanceof MultiResource) {
            for (Resource subResource : (MultiResource)value) {
                this.write(formFieldName, subResource);
            }
            return this;
        }
        this.beginPart();
        if (value instanceof Resource) {
            this.appendResource(formFieldName, (Resource)value);
        } else if (value instanceof File) {
            this.appendResource(formFieldName, new FileResource((File)value));
        } else if (value instanceof Path) {
            this.appendResource(formFieldName, new FileResource((Path)value));
        } else if (value instanceof byte[]) {
            this.appendResource(formFieldName, new BytesResource((byte[])value));
        } else if (value instanceof InputStream) {
            this.appendResource(formFieldName, new InputStreamResource((InputStream)value));
        } else if (value instanceof Reader) {
            this.appendResource(formFieldName, new InputStreamResource((Reader)value, this.charset));
        } else {
            this.appendResource(formFieldName, new StringResource(RsConvert.toStr(value), null, this.charset));
        }
        this.write("\r\n");
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void finish() throws IORuntimeException {
        if (!this.isFinish) {
            this.write(RsString.format("--{}--\r\n", this.boundary));
            this.isFinish = true;
        }
    }

    @Override
    public void close() {
        this.finish();
        RsIo.closeQuietly(this.out);
    }

    private void appendResource(String formFieldName, Resource resource) throws IORuntimeException {
        String fileName = resource.getName();
        if (null == fileName) {
            this.write(RsString.format(CONTENT_DISPOSITION_TEMPLATE, formFieldName));
        } else {
            this.write(RsString.format(CONTENT_DISPOSITION_FILE_TEMPLATE, formFieldName, fileName));
        }
        if (resource instanceof HttpResource) {
            String contentType = ((HttpResource)resource).getContentType();
            if (RsString.isNotBlank(contentType)) {
                this.write(RsString.format(CONTENT_TYPE_FILE_TEMPLATE, contentType));
            }
        } else if (RsString.isNotEmpty(fileName)) {
            this.write(RsString.format(CONTENT_TYPE_FILE_TEMPLATE, RsFile.getMimeType(fileName, ContentType.OCTET_STREAM.getValue())));
        }
        this.write("\r\n");
        resource.writeTo(this);
    }

    private void beginPart() {
        this.write("--", this.boundary, "\r\n");
    }

    private void write(CharSequence ... contents) {
        RsIo.writeStrs(this, this.charset, false, contents);
    }
}

