/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto.openssl;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsByte;

public class SaltMagic {
    public static final byte SALT_LEN = 8;
    public static final byte[] SALTED_MAGIC = "Salted__".getBytes(StandardCharsets.US_ASCII);
    public static final int MAGIC_SALT_LENGTH = SALTED_MAGIC.length + 8;

    public static byte[] getData(byte[] encryptedData) {
        if (RsArray.startWith(encryptedData, SALTED_MAGIC)) {
            return Arrays.copyOfRange(encryptedData, SALTED_MAGIC.length + 8, encryptedData.length);
        }
        return encryptedData;
    }

    public static byte[] getSalt(byte[] encryptedData) {
        if (RsArray.startWith(encryptedData, SALTED_MAGIC)) {
            return Arrays.copyOfRange(encryptedData, SALTED_MAGIC.length, MAGIC_SALT_LENGTH);
        }
        return null;
    }

    public static byte[] addMagic(byte[] data, byte[] salt) {
        if (null == salt) {
            return data;
        }
        Assert.isTrue(8 == salt.length);
        return RsByte.concat(SALTED_MAGIC, salt, data);
    }
}

