/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto.openssl;

import java.security.MessageDigest;
import java.util.Arrays;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsByte;
import top.redscorpion.core.util.RsString;
import top.redscorpion.crypto.digest.Md5;

public class OpenSSLSaltParser {
    private final MessageDigest digest;
    private final int keyLength;
    private final int ivLength;
    private String algorithm;

    public static OpenSSLSaltParser ofMd5(int keyLength, String algorithm) {
        return OpenSSLSaltParser.of((MessageDigest)Md5.of().getRaw(), keyLength, algorithm);
    }

    public static OpenSSLSaltParser of(MessageDigest digest, int keyLength, String algorithm) {
        return new OpenSSLSaltParser(digest, keyLength, algorithm);
    }

    public OpenSSLSaltParser(MessageDigest digest, int keyLength, String algorithm) {
        int ivLength = 16;
        if (RsString.containsIgnoreCase(algorithm, "des")) {
            ivLength = 8;
        }
        this.digest = digest;
        this.keyLength = keyLength;
        this.ivLength = ivLength;
        this.algorithm = algorithm;
    }

    public byte[][] getKeyAndIv(byte[] pass, byte[] salt) {
        byte[][] keyAndIvResult = new byte[2][];
        if (null == salt) {
            keyAndIvResult[0] = pass;
            return keyAndIvResult;
        }
        Assert.isTrue(8 == salt.length);
        byte[] passAndSalt = RsByte.concat(pass, salt);
        byte[] hash = new byte[]{};
        byte[] keyAndIv = new byte[]{};
        for (int i = 0; i < 3 && keyAndIv.length < this.keyLength + this.ivLength; ++i) {
            byte[] hashData = RsByte.concat(hash, passAndSalt);
            hash = this.digest.digest(hashData);
            keyAndIv = RsByte.concat(keyAndIv, hash);
        }
        keyAndIvResult[0] = Arrays.copyOfRange(keyAndIv, 0, this.keyLength);
        if (!RsString.containsAnyIgnoreCase(this.algorithm, "RC", "DES")) {
            keyAndIvResult[1] = Arrays.copyOfRange(keyAndIv, this.keyLength, this.keyLength + this.ivLength);
        }
        return keyAndIvResult;
    }
}

