/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.crypto.digest;

import java.security.MessageDigest;
import top.redscorpion.crypto.RsSecure;

public class DigesterFactory {
    private final MessageDigest prototype;
    private final boolean cloneSupport;

    public static DigesterFactory ofJdk(String algorithm) {
        return DigesterFactory.of(RsSecure.createJdkMessageDigest(algorithm));
    }

    public static DigesterFactory of(MessageDigest messageDigest) {
        return new DigesterFactory(messageDigest);
    }

    private DigesterFactory(MessageDigest messageDigest) {
        this.prototype = messageDigest;
        this.cloneSupport = DigesterFactory.checkCloneSupport(messageDigest);
    }

    public MessageDigest createMessageDigester() {
        if (this.cloneSupport) {
            try {
                return (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return RsSecure.createJdkMessageDigest(this.prototype.getAlgorithm());
    }

    private static boolean checkCloneSupport(MessageDigest messageDigest) {
        try {
            messageDigest.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }
}

