/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.xml;

import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.xml.RsXXE;

public class XmlWriter {
    private final Source source;
    private Charset charset = RsCharset.UTF_8;
    private int indent;
    private boolean omitXmlDeclaration;

    public static XmlWriter of(Node node) {
        return XmlWriter.of(new DOMSource(node));
    }

    public static XmlWriter of(Source source) {
        return new XmlWriter(source);
    }

    public XmlWriter(Source source) {
        this.source = source;
    }

    public XmlWriter setCharset(Charset charset) {
        if (null != charset) {
            this.charset = charset;
        }
        return this;
    }

    public XmlWriter setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public XmlWriter setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
        return this;
    }

    public void write(Writer writer) {
        this.write(new StreamResult(writer));
    }

    public void write(Result result) {
        TransformerFactory factory = RsXXE.disableXXE(TransformerFactory.newInstance());
        try {
            Transformer xformer = factory.newTransformer();
            if (this.indent > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("doctype-public", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(this.indent));
            }
            if (RsObject.isNotNull(this.charset)) {
                xformer.setOutputProperty("encoding", this.charset.name());
            }
            if (this.omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(this.source, result);
        }
        catch (Exception e) {
            throw new RsException(e, "Trans xml document to string error!", new Object[0]);
        }
    }
}

