/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import top.redscorpion.core.collection.iter.EnumerationIter;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.resource.ClassPathResource;
import top.redscorpion.core.io.resource.FileResource;
import top.redscorpion.core.io.resource.JarResource;
import top.redscorpion.core.io.resource.MultiResource;
import top.redscorpion.core.io.resource.NoResourceException;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.io.resource.UrlResource;
import top.redscorpion.core.util.RsClassLoader;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsUrlProtocol;

public class RsResource {
    public static InputStream getStreamSafe(String resource) {
        try {
            return RsResource.getResource(resource).getStream();
        }
        catch (NoResourceException noResourceException) {
            return null;
        }
    }

    public static URL getResourceUrl(String resource) throws IORuntimeException {
        return RsResource.getResourceUrl(resource, null);
    }

    public static EnumerationIter<URL> getResourceUrlIter(String resource, ClassLoader classLoader) {
        Enumeration<URL> resources;
        try {
            resources = RsObject.defaultIfNull(classLoader, RsClassLoader::getClassLoader).getResources(resource);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new EnumerationIter<URL>(resources);
    }

    public static URL getResourceUrl(String resource, Class<?> baseClass) {
        resource = RsString.toStringOrEmpty(resource);
        return null != baseClass ? baseClass.getResource(resource) : RsClassLoader.getClassLoader().getResource(resource);
    }

    public static Resource getResource(String path) {
        if (RsString.isNotBlank(path) && (RsString.startWithAny(path, "file:", "project:") || RsFile.isAbsolutePath(path))) {
            return new FileResource(path);
        }
        return new ClassPathResource(path);
    }

    public static Resource getResource(URL url) {
        if (RsUrlProtocol.isJarUrl(url)) {
            return new JarResource(url);
        }
        if (RsUrlProtocol.isFileUrl(url)) {
            return new FileResource(url.getFile());
        }
        return new UrlResource(url);
    }

    public static MultiResource getResources(String resource, ClassLoader classLoader) {
        EnumerationIter<URL> iter = RsResource.getResourceUrlIter(resource, classLoader);
        MultiResource resources = new MultiResource(new Resource[0]);
        for (URL url : iter) {
            resources.add(RsResource.getResource(url));
        }
        return resources;
    }
}

