/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.net.HttpCookie;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;

public class RsNet {
    public static LinkedHashSet<InetAddress> localAddressList(Predicate<InetAddress> addressPredicate) {
        return RsNet.localAddressList(null, addressPredicate);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Predicate<NetworkInterface> networkInterfaceFilter, Predicate<InetAddress> addressPredicate) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RsException(e);
        }
        Assert.notNull(networkInterfaces, () -> new RsException("Get network interface error!"));
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterfaceFilter != null && !networkInterfaceFilter.test(networkInterface)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressPredicate && !addressPredicate.test(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && RsString.indexOf((CharSequence)ip, ',') > 0) {
            List<String> ips = RsSplit.splitTrim(ip, ",");
            for (String subIp : ips) {
                if (RsNet.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return RsString.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (RsString.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }
}

