/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import top.redscorpion.core.func.LambdaFactory;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.method.RsMethod;
import top.redscorpion.core.util.RsModifier;

public class RsLambda {
    public static <T, R> Function<T, R> buildGetter(Method getMethod) {
        return LambdaFactory.build(Function.class, getMethod);
    }

    public static <T, P> BiConsumer<T, P> buildSetter(Method setMethod) {
        Class<?> returnType = setMethod.getReturnType();
        if (Void.TYPE == returnType) {
            return LambdaFactory.build(BiConsumer.class, setMethod);
        }
        BiFunction biFunction = LambdaFactory.build(BiFunction.class, setMethod);
        return biFunction::apply;
    }

    public static Method getInvokeMethod(Class<?> funcType) {
        Method[] abstractMethods = RsMethod.getPublicMethods(funcType, RsModifier::isAbstract);
        Assert.equals(abstractMethods.length, 1, "Not a function class: " + funcType.getName(), new Object[0]);
        return abstractMethods[0];
    }
}

