/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystem;

public class RsJdk {
    public static final int JVM_VERSION = RsJdk.theGetJvmVersion();
    public static final boolean IS_JDK8 = 8 == JVM_VERSION;
    public static final boolean IS_AT_LEAST_JDK17 = JVM_VERSION >= 17;
    public static final boolean IS_ANDROID;
    public static final boolean IS_OPENJ9;
    public static final boolean IS_GRAALVM_NATIVE;

    private static String theGetJvmName() {
        return RsSystem.getQuietly("java.vm.name");
    }

    private static int theGetJvmVersion() {
        int jvmVersion = 8;
        String javaSpecVer = RsSystem.getQuietly("java.specification.version");
        if (RsString.isNotBlank(javaSpecVer)) {
            if (javaSpecVer.startsWith("1.")) {
                javaSpecVer = javaSpecVer.substring(2);
            }
            if (javaSpecVer.indexOf(46) == -1) {
                jvmVersion = Integer.parseInt(javaSpecVer);
            }
        }
        return jvmVersion;
    }

    static {
        String jvmName = RsJdk.theGetJvmName();
        IS_ANDROID = "Dalvik".equals(jvmName);
        IS_OPENJ9 = jvmName.contains("OpenJ9");
        IS_GRAALVM_NATIVE = null != System.getProperty("org.graalvm.nativeimage.imagecode");
    }
}

