/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.Date;
import top.redscorpion.core.data.CIN;
import top.redscorpion.core.data.CIN10;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsString;

public class RsIdcard {
    public static boolean isValidCard(String idCard) {
        if (RsString.isBlank(idCard)) {
            return false;
        }
        int length = idCard.length();
        switch (length) {
            case 18: {
                return RsIdcard.isValidCard18(idCard);
            }
            case 15: {
                try {
                    return RsIdcard.isValidCard18(CIN.convert15To18(idCard));
                }
                catch (Exception ignore) {
                    return false;
                }
            }
            case 10: {
                return RsIdcard.isValidCard10(idCard);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idcard) {
        return RsIdcard.isValidCard18(idcard, true);
    }

    public static boolean isValidCard18(String idcard, boolean ignoreCase) {
        return CIN.verify(idcard, ignoreCase);
    }

    public static boolean isValidCard10(String idcard) {
        try {
            return CIN10.of(idcard).isVerified();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static DateTime getBirthDate(String idCard) {
        return RsIdcard.getCIN(idCard).getBirthDate();
    }

    public static int getAge(String idcard) {
        return RsIdcard.getAge(idcard, RsDate.date());
    }

    public static int getAge(String idcard, Date dateToCompare) {
        return RsDate.age(RsIdcard.getBirthDate(idcard), dateToCompare);
    }

    public static int getGender(String idcard) {
        return RsIdcard.getCIN(idcard).getGender();
    }

    public static CIN getCIN(String idcard) {
        return CIN.of(idcard);
    }
}

