/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.Year;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import top.redscorpion.core.date.BetweenFormatter;
import top.redscorpion.core.date.DateBetween;
import top.redscorpion.core.date.DateField;
import top.redscorpion.core.date.DateFormatPool;
import top.redscorpion.core.date.DateRange;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.DateUnit;
import top.redscorpion.core.date.StopWatch;
import top.redscorpion.core.date.format.DateFormatManager;
import top.redscorpion.core.date.format.DatePrinter;
import top.redscorpion.core.date.format.FastDateFormat;
import top.redscorpion.core.date.format.parser.PositionDateParser;
import top.redscorpion.core.date.format.parser.RegisterDateParser;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsCalendar;
import top.redscorpion.core.util.RsCompare;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystem;
import top.redscorpion.core.util.RsTemporalAccessor;

public class RsDate {
    public static DateTime date(Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime date(long date) {
        return new DateTime(date);
    }

    public static DateTime date(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new DateTime(calendar);
    }

    public static DateTime date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return new DateTime(temporalAccessor);
    }

    public static String formatNow() {
        return RsDate.formatDateTime(new DateTime());
    }

    public static String formatToday() {
        return RsDate.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int thisYear() {
        return RsDate.year(new DateTime());
    }

    public static String format(Date date, String format) {
        if (null == date || RsString.isBlank(format)) {
            return null;
        }
        DateFormatManager formatManager = DateFormatManager.getInstance();
        if (formatManager.isCustomFormat(format)) {
            return formatManager.format(date, (CharSequence)format);
        }
        TimeZone timeZone = null;
        if (date instanceof DateTime) {
            timeZone = ((DateTime)date).getTimeZone();
        }
        return RsDate.format(date, FastDateFormat.getInstance(format, timeZone));
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DateFormatPool.NORM_DATETIME_FORMAT.format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DateFormatPool.NORM_DATE_FORMAT.format(date);
    }

    public static DateTime parse(CharSequence dateStr, PositionDateParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(CharSequence dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        return (DateTime)RegisterDateParser.INSTANCE.parse(dateCharSequence);
    }

    public static DateTime beginOfDay(Date date) {
        return new DateTime(RsCalendar.beginOfDay(RsCalendar.calendar(date)));
    }

    public static DateTime endOfDay(Date date, boolean truncateMillisecond) {
        return new DateTime(RsCalendar.endOfDay(RsCalendar.calendar(date), truncateMillisecond));
    }

    public static DateTime beginOfMonth(Date date) {
        return new DateTime(RsCalendar.beginOfMonth(RsCalendar.calendar(date)));
    }

    public static DateTime endOfMonth(Date date, boolean truncateMillisecond) {
        return new DateTime(RsCalendar.endOfMonth(RsCalendar.calendar(date), truncateMillisecond));
    }

    public static DateTime beginOfQuarter(Date date) {
        return new DateTime(RsCalendar.beginOfQuarter(RsCalendar.calendar(date)));
    }

    public static DateTime endOfQuarter(Date date, boolean truncateMillisecond) {
        return new DateTime(RsCalendar.endOfQuarter(RsCalendar.calendar(date), truncateMillisecond));
    }

    public static DateTime beginOfYear(Date date) {
        return new DateTime(RsCalendar.beginOfYear(RsCalendar.calendar(date)));
    }

    public static DateTime endOfYear(Date date, boolean truncateMillisecond) {
        return new DateTime(RsCalendar.endOfYear(RsCalendar.calendar(date), truncateMillisecond));
    }

    public static DateTime yesterday() {
        return RsDate.offsetDay(new DateTime(), -1);
    }

    public static DateTime tomorrow() {
        return RsDate.offsetDay(new DateTime(), 1);
    }

    public static DateTime offsetDay(Date date, int offset) {
        return RsDate.offset(date, DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetMonth(Date date, int offset) {
        return RsDate.offset(date, DateField.MONTH, offset);
    }

    public static DateTime offsetYear(Date date, int offset) {
        return RsDate.offset(date, DateField.YEAR, offset);
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        if (date == null) {
            return null;
        }
        return RsDate.date(date).offset(dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return RsDate.between(beginDate, endDate, unit, true);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit, boolean isAbs) {
        return new DateBetween(beginDate, endDate, isAbs).between(unit);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = RsDate.beginOfDay(beginDate);
            endDate = RsDate.beginOfDay(endDate);
        }
        return RsDate.between(beginDate, endDate, DateUnit.DAY);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static String formatBetween(long betweenMs, BetweenFormatter.Level level) {
        return BetweenFormatter.of(betweenMs, level).format();
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static int age(Date birthday, Date dateToCompare) {
        Assert.notNull(birthday, "Birthday can not be null !", new Object[0]);
        if (null == dateToCompare) {
            dateToCompare = RsDate.date();
        }
        return RsCalendar.age(birthday.getTime(), dateToCompare.getTime());
    }

    public static DateRange range(Date start, Date end, DateField unit) {
        return new DateRange(start, end, unit);
    }

    public static List<DateTime> rangeToList(Date start, Date end, DateField unit) {
        return RsList.of(RsDate.range(start, end, unit));
    }

    public static int compare(Date date1, Date date2) {
        return RsCompare.compare(date1, date2);
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        return RsTemporalAccessor.toInstant(temporalAccessor);
    }

    public static boolean isGlobalLenient() {
        return RsSystem.getBoolean("rs.date.lenient", false);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return RsDate.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        return RsDate.newSimpleFormat(pattern, locale, timeZone, RsDate.isGlobalLenient());
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone, boolean lenient) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(lenient);
        return format;
    }

    public static String getShortName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return unit.name().toLowerCase();
    }

    public static DateTime date() {
        return new DateTime();
    }

    public static DateTime today() {
        return RsDate.parseDate(new DateTime().toJdkDate());
    }

    public static DateTime parseDate(CharSequence dateStr) {
        return RsDate.parse(dateStr, "yyyy-MM-dd");
    }

    public static DateTime parseDate(Date date) {
        return RsDate.parseDate(RsDate.formatDate(date));
    }

    public static DateTime beginOfDay(CharSequence dateStr) {
        return RsDate.beginOfDay(RsDate.parse(dateStr).toJdkDate());
    }

    public static DateTime endOfDay(CharSequence dateStr) {
        return RsDate.endOfDay(RsDate.parse(dateStr).toJdkDate(), true);
    }

    public static DateTime endOfDay(Date date) {
        return RsDate.endOfDay(date, true);
    }

    public static DateTime endOfMonth(Date date) {
        return RsDate.endOfMonth(date, true);
    }

    public static DateTime endOfQuarter(Date date) {
        return RsDate.endOfQuarter(date, true);
    }

    public static DateTime endOfYear(Date date) {
        return RsDate.endOfYear(date, true);
    }

    public static StopWatch timer() {
        return new StopWatch();
    }

    public static StopWatch timer(String id) {
        return new StopWatch(id);
    }
}

