/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.HashMap;
import java.util.Map;
import top.redscorpion.core.enums.ErrorCode;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.vo.Result;

public class R {
    public static final ErrorCode SUCCESS = ErrorCode.SUCCESS;
    public static final ErrorCode ERROR = ErrorCode.ERROR;

    private R() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> Result<T> success() {
        return R.success(SUCCESS.getMessage());
    }

    public static <T> Result<T> success(String message) {
        Result result = new Result();
        result.setSuccess(true);
        result.setCode(SUCCESS.getCode());
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> data(T t) {
        return R.data(t, SUCCESS.getMessage());
    }

    public static <T> Result<T> data(T t, String message) {
        Result<T> result = new Result<T>();
        result.setSuccess(true);
        result.setCode(SUCCESS.getCode());
        result.setMessage(message);
        result.setData(t);
        return result;
    }

    public static <T> Result<T> error() {
        return R.error(ERROR);
    }

    public static <T> Result<T> error(String message) {
        return R.error(ERROR.getCode(), message);
    }

    public static <T> Result<T> error(String code, String message) {
        Result result = new Result();
        result.setSuccess(false);
        result.setCode(code);
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> error(ErrorCode errorCode) {
        return R.error(errorCode.getCode(), errorCode.getMessage());
    }

    public static <T> Result<T> error(ErrorCode errorCode, String message) {
        return R.error(errorCode.getCode(), message);
    }

    public static Map<String, Object> errorMap(String code, String message) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", false);
        resultMap.put("code", code);
        resultMap.put("message", message);
        resultMap.put("timestamp", System.currentTimeMillis());
        return resultMap;
    }

    public static <T> Result<T> successLog(String name, String message) {
        RsFile.logOut("", name, message);
        return R.success();
    }

    public static <T> Result<T> successLog(String path, String name, String message) {
        RsFile.logOut(path, name, message);
        return R.success(message);
    }

    public static <T> Result<T> dataLog(String name, T t, String message) {
        RsFile.logOut("", name, message);
        return R.data(t, message);
    }

    public static <T> Result<T> dataLog(String path, String name, T t, String message) {
        RsFile.logOut(path, name, message);
        return R.data(t, message);
    }

    public static <T> Result<T> errorLog(String name, String message) {
        RsFile.logOut("", name, message);
        return R.error(message);
    }

    public static <T> Result<T> errorLog(String path, String name, String message) {
        RsFile.logOut(path, name, message);
        return R.error(message);
    }

    public static <T> Result<T> errorLog(String path, String name, String code, String message) {
        RsFile.logOut(path, name, message);
        return R.error(code, message);
    }
}

