/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text.placeholder.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.text.placeholder.AbstractStringTemplate;
import top.redscorpion.core.text.placeholder.segment.AbstractPlaceholderSegment;
import top.redscorpion.core.text.placeholder.segment.IndexedPlaceholderSegment;
import top.redscorpion.core.text.placeholder.segment.LiteralSegment;
import top.redscorpion.core.text.placeholder.segment.NamedPlaceholderSegment;
import top.redscorpion.core.text.placeholder.segment.StringTemplateSegment;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsNumber;

public class NamedPlaceholderStringTemplate
extends AbstractStringTemplate {
    public static final String DEFAULT_PREFIX = "{";
    public static final String DEFAULT_SUFFIX = "}";
    protected String prefix;
    protected String suffix;
    protected int indexedSegmentMaxIdx = 0;

    protected NamedPlaceholderStringTemplate(String template, int features, String prefix, String suffix, char escape, String defaultValue, UnaryOperator<String> defaultValueHandler) {
        super(template, escape, defaultValue, defaultValueHandler, features);
        Assert.notEmpty(prefix);
        Assert.notEmpty(suffix);
        this.prefix = prefix;
        this.suffix = suffix;
        this.afterInit();
        if (!this.placeholderSegments.isEmpty()) {
            for (AbstractPlaceholderSegment segment : this.placeholderSegments) {
                if (!(segment instanceof IndexedPlaceholderSegment)) continue;
                this.indexedSegmentMaxIdx = Math.max(this.indexedSegmentMaxIdx, ((IndexedPlaceholderSegment)segment).getIndex());
            }
        }
    }

    @Override
    protected List<StringTemplateSegment> parseSegments(String template) {
        int openCursor = template.indexOf(this.prefix);
        if (openCursor == -1) {
            return Collections.singletonList(new LiteralSegment(template));
        }
        int openLength = this.prefix.length();
        int closeLength = this.suffix.length();
        ArrayList<StringTemplateSegment> segments = new ArrayList<StringTemplateSegment>();
        int closeCursor = 0;
        char[] src = template.toCharArray();
        StringBuilder expression = new StringBuilder(16);
        boolean hasDoubleEscape = false;
        boolean isLastLiteralSegment = false;
        while (openCursor > -1) {
            if (openCursor > 0 && src[openCursor - 1] == this.escape) {
                if (openCursor > 1 && src[openCursor - 2] == this.escape) {
                    hasDoubleEscape = true;
                } else {
                    this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor, openCursor - 1) + this.prefix);
                    isLastLiteralSegment = true;
                    closeCursor = openCursor + openLength;
                    openCursor = template.indexOf(this.prefix, closeCursor);
                    continue;
                }
            }
            if (!hasDoubleEscape) {
                if (closeCursor < openCursor) {
                    this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor, openCursor));
                }
            } else {
                hasDoubleEscape = false;
                this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor, openCursor - 1));
            }
            closeCursor = openCursor + openLength;
            int end = template.indexOf(this.suffix, closeCursor);
            while (end > -1) {
                if (end > closeCursor && src[end - 1] == this.escape) {
                    if (end > 1 && src[end - 2] == this.escape) {
                        expression.append(src, closeCursor, end - closeCursor - 1);
                        break;
                    }
                    expression.append(src, closeCursor, end - closeCursor - 1).append(this.suffix);
                    closeCursor = end + closeLength;
                    end = template.indexOf(this.suffix, closeCursor);
                    continue;
                }
                expression.append(src, closeCursor, end - closeCursor);
                break;
            }
            if (end == -1) {
                throw new RsException("\"{}\" \u4e2d\u5b57\u7b26\u4e0b\u6807 {} \u5904\u7684\u5f00\u59cb\u7b26\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ed3\u675f\u7b26", template, openCursor);
            }
            String variableName = expression.toString();
            expression.setLength(0);
            String wholePlaceholder = expression.append(this.prefix).append(variableName).append(this.suffix).toString();
            expression.setLength(0);
            if (RsNumber.isInteger(variableName)) {
                segments.add(new IndexedPlaceholderSegment(variableName, wholePlaceholder));
            } else {
                segments.add(new NamedPlaceholderSegment(variableName, wholePlaceholder));
            }
            isLastLiteralSegment = false;
            closeCursor = end + closeLength;
            openCursor = template.indexOf(this.prefix, closeCursor);
        }
        if (closeCursor < src.length) {
            this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor));
        }
        return segments;
    }

    public String formatSequence(Object ... args) {
        return this.formatArraySequence(args);
    }

    public String formatArraySequence(Object array) {
        return this.formatArraySequence(RsArray.wrap(array));
    }

    public String formatArraySequence(Object[] array) {
        if (array == null) {
            return this.getTemplate();
        }
        return this.formatSequence(Arrays.asList(array));
    }

    @Override
    public String formatSequence(Iterable<?> iterable) {
        return super.formatSequence(iterable);
    }

    public String formatIndexed(Object ... args) {
        return this.formatArrayIndexed(args);
    }

    public String formatArrayIndexed(Object array) {
        return this.formatArrayIndexed(RsArray.wrap(array));
    }

    public String formatArrayIndexed(Object[] array) {
        if (array == null) {
            return this.getTemplate();
        }
        return this.formatIndexed(Arrays.asList(array));
    }

    public String formatIndexed(Collection<?> collection) {
        return this.formatIndexed(collection, null);
    }

    public String formatIndexed(Collection<?> collection, IntFunction<String> missingIndexHandler) {
        if (collection == null) {
            return this.getTemplate();
        }
        int size = collection.size();
        boolean isList = collection instanceof List;
        return this.formatBySegment(segment -> {
            int index = ((IndexedPlaceholderSegment)segment).getIndex();
            if (index < 0) {
                index += size;
            }
            if (index >= 0 && index < size) {
                if (isList) {
                    return ((List)collection).get(index);
                }
                return RsColl.get(collection, index);
            }
            if (missingIndexHandler != null) {
                return missingIndexHandler.apply(index);
            }
            return this.formatMissingKey((AbstractPlaceholderSegment)segment);
        });
    }

    public String format(Object beanOrMap) {
        if (beanOrMap == null) {
            return this.getTemplate();
        }
        if (beanOrMap instanceof Map) {
            return this.format((Map)beanOrMap);
        }
        return this.format((String fieldName) -> RsBean.getProperty(beanOrMap, fieldName));
    }

    public String format(Map<String, ?> map) {
        if (null == map) {
            return this.getTemplate();
        }
        return this.format(map::get, map::containsKey);
    }

    public String format(Function<String, ?> valueProvider) {
        if (valueProvider == null) {
            return this.getTemplate();
        }
        return this.formatBySegment(segment -> valueProvider.apply(segment.getPlaceholder()));
    }

    public String format(Function<String, ?> valueSupplier, Predicate<String> containsKey) {
        if (valueSupplier == null || containsKey == null) {
            return this.getTemplate();
        }
        return this.formatBySegment(segment -> {
            String placeholder = segment.getPlaceholder();
            if (containsKey.test(placeholder)) {
                return valueSupplier.apply(placeholder);
            }
            return this.formatMissingKey((AbstractPlaceholderSegment)segment);
        });
    }

    public String[] matchesSequenceToArray(String str) {
        return this.matchesSequence(str).toArray(new String[0]);
    }

    @Override
    public List<String> matchesSequence(String str) {
        return super.matchesSequence(str);
    }

    public String[] matchesIndexedToArray(String str) {
        return this.matchesIndexed(str, null).toArray(new String[0]);
    }

    public String[] matchesIndexedToArray(String str, IntFunction<String> missingIndexHandler) {
        return this.matchesIndexed(str, missingIndexHandler).toArray(new String[0]);
    }

    public List<String> matchesIndexed(String str) {
        return this.matchesIndexed(str, null);
    }

    public List<String> matchesIndexed(String str, IntFunction<String> missingIndexHandler) {
        if (str == null || this.placeholderSegments.isEmpty() || !this.isMatches(str)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> params = new ArrayList<String>(this.indexedSegmentMaxIdx + 1);
        RsList.setOrPadding(params, this.indexedSegmentMaxIdx, null, null);
        this.matchesIndexed(str, params::set, missingIndexHandler);
        return params;
    }

    public void matchesIndexed(String str, BiConsumer<Integer, String> idxValueConsumer, IntFunction<String> missingIndexHandler) {
        if (str == null || RsColl.isEmpty(this.placeholderSegments) || !this.isMatches(str)) {
            return;
        }
        if (missingIndexHandler == null) {
            this.matchesByKey(str, (key, value) -> idxValueConsumer.accept(Integer.parseInt(key), (String)value));
        } else {
            this.matchesByKey(str, (key, value) -> idxValueConsumer.accept(Integer.parseInt(key), (String)value), true, segment -> {
                if (segment instanceof IndexedPlaceholderSegment) {
                    return (String)missingIndexHandler.apply(((IndexedPlaceholderSegment)segment).getIndex());
                }
                return this.getDefaultValue((AbstractPlaceholderSegment)segment);
            });
        }
    }

    public Map<String, String> matches(String str) {
        return this.matches(str, HashMap::new);
    }

    public <T> T matches(String str, Supplier<T> beanOrMapSupplier) {
        Assert.notNull(beanOrMapSupplier, "beanOrMapSupplier cannot be null", new Object[0]);
        Object obj = beanOrMapSupplier.get();
        if (str == null || obj == null || this.placeholderSegments.isEmpty() || !this.isMatches(str)) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            this.matchesByKey(str, map::put);
        } else if (RsBean.isWritableBean(obj.getClass())) {
            this.matchesByKey(str, (key, value) -> RsBean.setProperty(obj, key, value));
        }
        return obj;
    }

    public static Builder builder(String template) {
        return new Builder(template);
    }

    public static class Builder
    extends AbstractStringTemplate.AbstractBuilder<Builder, NamedPlaceholderStringTemplate> {
        protected String prefix;
        protected String suffix;

        protected Builder(String template) {
            super(template);
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        protected NamedPlaceholderStringTemplate buildInstance() {
            if (this.prefix == null) {
                this.prefix = NamedPlaceholderStringTemplate.DEFAULT_PREFIX;
            }
            if (this.suffix == null) {
                this.suffix = NamedPlaceholderStringTemplate.DEFAULT_SUFFIX;
            }
            return new NamedPlaceholderStringTemplate(this.template, this.features, this.prefix, this.suffix, this.escape, this.defaultValue, this.defaultValueHandler);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

