/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text.finder;

import java.io.Serializable;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.text.finder.Finder;

public abstract class AbstractTextFinder
implements Finder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected CharSequence text;
    protected int endIndex = -1;
    protected boolean negative;

    public AbstractTextFinder setText(CharSequence text) {
        this.text = Assert.notNull(text, "Text must be not null!", new Object[0]);
        return this;
    }

    public AbstractTextFinder setEndIndex(int endIndex) {
        this.endIndex = endIndex;
        return this;
    }

    public AbstractTextFinder setNegative(boolean negative) {
        this.negative = negative;
        return this;
    }

    protected int getValidEndIndex() {
        if (this.negative && -1 == this.endIndex) {
            return -1;
        }
        int limit = this.endIndex < 0 ? this.endIndex + this.text.length() + 1 : Math.min(this.endIndex, this.text.length());
        return limit;
    }
}

