/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.method;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import top.redscorpion.core.bean.NullWrapperBean;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.reference.WeakConcurrentMap;
import top.redscorpion.core.reflect.method.MethodInvoker;
import top.redscorpion.core.reflect.method.MethodReflect;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsBoolean;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsString;

public class RsMethod {
    private static final WeakConcurrentMap<Class<?>, MethodReflect> METHODS_CACHE = new WeakConcurrentMap();

    public static Method getMethod(Method[] methods, Predicate<Method> predicate) {
        return RsArray.get(methods, predicate);
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || RsString.isBlank(methodName)) {
            return null;
        }
        return RsMethod.getMethod(obj.getClass(), methodName, RsClass.getClasses(args));
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return RsMethod.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || RsString.isBlank(methodName)) {
            return null;
        }
        return RsMethod.getMethod(RsMethod.getMethods(clazz), ignoreCase, methodName, paramTypes);
    }

    public static Method getMethod(Method[] methods, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (RsArray.isEmpty(methods) || RsString.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        if (RsArray.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!RsString.equals(methodName, method.getName(), ignoreCase) || !RsClass.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return RsMethod.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || RsString.isBlank(methodName)) {
            return null;
        }
        Method[] methods = RsMethod.getMethods(clazz, method -> RsString.equals(methodName, method.getName(), ignoreCase) && method.getReturnType().isAssignableFrom(method.getReturnType()));
        return RsArray.isEmpty(methods) ? null : methods[0];
    }

    public static Method[] getMethods(Class<?> clazz) throws SecurityException {
        return RsMethod.getMethods(clazz, null);
    }

    public static Method[] getMethods(Class<?> clazz, Predicate<Method> predicate) throws SecurityException {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getAllMethods(predicate);
    }

    public static Method[] getPublicMethods(Class<?> clazz, Predicate<Method> predicate) {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getPublicMethods(predicate);
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return RsMethod.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        int parameterCount = method.getParameterCount();
        switch (parameterCount) {
            case 0: {
                return RsMethod.isGetter(method, ignoreCase);
            }
            case 1: {
                return RsMethod.isSetter(method, ignoreCase);
            }
        }
        return false;
    }

    public static boolean isSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (1 != parameterCount) {
            return false;
        }
        String name = method.getName();
        if (name.length() < 4) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        return name.startsWith("set");
    }

    public static boolean isGetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        if (0 != method.getParameterCount()) {
            return false;
        }
        if (Void.class == method.getReturnType()) {
            return false;
        }
        String name = method.getName();
        if (name.length() < 3 || "getClass".equals(name) || "get".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        if (name.startsWith("is")) {
            return RsBoolean.isBoolean(method.getReturnType());
        }
        return name.startsWith("get");
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws RsException {
        return RsMethod.invoke(null, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws RsException {
        return MethodInvoker.of(method).invoke(obj, args);
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws RsException {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = RsMethod.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new RsException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return RsMethod.invoke(obj, method, args);
    }

    public static Object[] actualArgs(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (1 == parameterTypes.length && parameterTypes[0].isArray()) {
            return args;
        }
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = RsClass.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapperBean) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = RsConvert.convert(parameterTypes[i], args[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        return actualArgs;
    }
}

