/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.creator;

import java.lang.invoke.MethodHandle;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.creator.ObjectCreator;
import top.redscorpion.core.reflect.lookup.RsLookup;
import top.redscorpion.core.reflect.method.RsMethodHandle;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsClassLoader;

public class DefaultObjectCreator<T>
implements ObjectCreator<T> {
    final MethodHandle constructor;
    final Object[] params;

    public static <T> DefaultObjectCreator<T> of(String fullClassName) {
        return DefaultObjectCreator.of(RsClassLoader.loadClass(fullClassName), new Object[0]);
    }

    public static <T> DefaultObjectCreator<T> of(Class<T> clazz, Object ... params) {
        return new DefaultObjectCreator<T>(clazz, params);
    }

    public DefaultObjectCreator(Class<T> clazz, Object ... params) {
        Class<?>[] paramTypes = RsClass.getClasses(params);
        this.constructor = RsLookup.findConstructor(clazz, paramTypes);
        Assert.notNull(this.constructor, "Constructor not found!", new Object[0]);
        this.params = params;
    }

    @Override
    public T create() {
        return RsMethodHandle.invokeHandle(this.constructor, this.params);
    }
}

