/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.Invoker;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsReflect;

public class FieldInvoker
implements Invoker {
    private final Field field;
    private Converter converter;

    public static FieldInvoker of(Field field) {
        return null == field ? null : new FieldInvoker(field);
    }

    public FieldInvoker(Field field) {
        this.field = Assert.notNull(field);
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Type getType() {
        return this.field.getGenericType();
    }

    @Override
    public Class<?> getTypeClass() {
        return this.field.getType();
    }

    public FieldInvoker setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) {
        if (RsArray.isEmpty(args)) {
            return (T)this.invokeGet(target);
        }
        if (args.length == 1) {
            this.invokeSet(target, args[0]);
            return null;
        }
        throw new RsException("Field [{}] cannot be set with [{}] args", this.field.getName(), args.length);
    }

    public Object invokeGet(Object obj) throws RsException {
        Object result;
        if (null == this.field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        RsReflect.setAccessible(this.field);
        try {
            result = this.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e, "IllegalAccess for {}.{}", this.field.getDeclaringClass(), this.field.getName());
        }
        return result;
    }

    public void invokeSet(Object obj, Object value) throws RsException {
        RsReflect.setAccessible(this.field);
        try {
            this.field.set(obj instanceof Class ? null : obj, this.convertValue(value));
        }
        catch (IllegalAccessException e) {
            throw new RsException(e, "IllegalAccess for [{}.{}]", null == obj ? this.field.getDeclaringClass() : obj, this.field.getName());
        }
    }

    private Object convertValue(Object value) {
        if (null == this.converter) {
            return value;
        }
        Class<?> fieldType = this.field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = this.converter.convert(fieldType, value))) {
                return targetValue;
            }
        } else {
            return RsClass.getDefaultValue(fieldType);
        }
        return value;
    }
}

