/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.builder.Builder;
import top.redscorpion.core.net.url.RFC3986;
import top.redscorpion.core.net.url.UrlPath;
import top.redscorpion.core.net.url.UrlQuery;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsUrl;

public final class UrlBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SCHEME = "http";
    private String scheme;
    private String host;
    private int port = -1;
    private UrlPath path;
    private UrlQuery query;
    private String fragment;
    private Charset charset;

    public static UrlBuilder of(UrlBuilder builder) {
        return UrlBuilder.of(builder.getScheme(), builder.getHost(), builder.getPort(), builder.getPathStr(), builder.getQueryStr(), builder.getFragment(), builder.getCharset());
    }

    public static UrlBuilder ofHttpWithoutEncode(String httpUrl) {
        return UrlBuilder.ofHttp(httpUrl, null);
    }

    public static UrlBuilder ofHttp(String httpUrl, Charset charset) {
        Assert.notBlank(httpUrl, "Http url must be not blank!", new Object[0]);
        httpUrl = RsString.trimPrefix(httpUrl);
        if (!RsString.startWithAnyIgnoreCase(httpUrl, "http://", "https://")) {
            httpUrl = "http://" + httpUrl;
        }
        return UrlBuilder.of(RsUrl.toUrlForHttp(httpUrl), charset);
    }

    public static UrlBuilder of(String url, Charset charset) {
        Assert.notBlank(url, "Url must be not blank!", new Object[0]);
        return UrlBuilder.of(RsUrl.url(RsString.trim(url)), charset);
    }

    public static UrlBuilder of(URL url, Charset charset) {
        return UrlBuilder.of(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef(), charset);
    }

    public static UrlBuilder of(String scheme, String host, int port, String path, String query, String fragment, Charset charset) {
        return UrlBuilder.of(scheme, host, port, UrlPath.of(path, charset), UrlQuery.of(query, charset, false), fragment, charset);
    }

    public static UrlBuilder of(String scheme, String host, int port, UrlPath path, UrlQuery query, String fragment, Charset charset) {
        return new UrlBuilder(scheme, host, port, path, query, fragment, charset);
    }

    public UrlBuilder() {
        this.charset = RsCharset.UTF_8;
    }

    public UrlBuilder(String scheme, String host, int port, UrlPath path, UrlQuery query, String fragment, Charset charset) {
        this.charset = charset;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.setFragment(fragment);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSchemeWithDefault() {
        return RsString.defaultIfEmpty(this.scheme, DEFAULT_SCHEME);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPathStr() {
        return null == this.path ? "/" : this.path.build(this.charset);
    }

    public UrlQuery getQuery() {
        return this.query;
    }

    public String getQueryStr() {
        return null == this.query ? null : this.query.build(this.charset);
    }

    public UrlBuilder setQuery(UrlQuery query) {
        this.query = query;
        return this;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getFragmentEncoded() {
        return RFC3986.FRAGMENT.encode(this.fragment, this.charset, new char[0]);
    }

    public UrlBuilder setFragment(String fragment) {
        if (RsString.isEmpty(fragment)) {
            this.fragment = null;
        }
        this.fragment = RsString.removePrefix(fragment, "#");
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public UrlBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String build() {
        return this.toUrl().toString();
    }

    public URL toUrl() {
        return this.toUrl(null);
    }

    public URL toUrl(URLStreamHandler handler) {
        StringBuilder fileBuilder = new StringBuilder();
        fileBuilder.append(this.getPathStr());
        String query = this.getQueryStr();
        if (RsString.isNotBlank(query)) {
            fileBuilder.append('?').append(query);
        }
        if (RsString.isNotBlank(this.fragment)) {
            fileBuilder.append('#').append(this.getFragmentEncoded());
        }
        try {
            return new URL(this.getSchemeWithDefault(), this.host, this.port, fileBuilder.toString(), handler);
        }
        catch (MalformedURLException e) {
            throw new RsException(e);
        }
    }

    public URI toUri() {
        try {
            return this.toUrl().toURI();
        }
        catch (URISyntaxException e) {
            throw new RsException(e);
        }
    }

    public String toString() {
        return this.build();
    }
}

