/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.url;

import top.redscorpion.core.codec.PercentCodec;

public class RFC3986 {
    public static final PercentCodec SUB_DELIMS = PercentCodec.Builder.of("!$&'()*+,;=").build();
    public static final PercentCodec UNRESERVED = PercentCodec.Builder.of(RFC3986.unreservedChars()).build();
    public static final PercentCodec PCHAR;
    public static final PercentCodec SEGMENT;
    public static final PercentCodec SEGMENT_NZ_NC;
    public static final PercentCodec PATH;
    public static final PercentCodec QUERY;
    public static final PercentCodec FRAGMENT;
    public static final PercentCodec QUERY_PARAM_VALUE;
    public static final PercentCodec QUERY_PARAM_VALUE_STRICT;
    public static final PercentCodec QUERY_PARAM_NAME;
    public static final PercentCodec QUERY_PARAM_NAME_STRICT;

    private static StringBuilder unreservedChars() {
        char c;
        StringBuilder sb = new StringBuilder();
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        sb.append("_.-~");
        return sb;
    }

    static {
        SEGMENT = PCHAR = PercentCodec.Builder.of(UNRESERVED).or(SUB_DELIMS).addSafes(":@").build();
        SEGMENT_NZ_NC = PercentCodec.Builder.of(SEGMENT).removeSafe(':').build();
        PATH = PercentCodec.Builder.of(SEGMENT).addSafe('/').build();
        FRAGMENT = QUERY = PercentCodec.Builder.of(PCHAR).addSafes("/?").build();
        QUERY_PARAM_VALUE = PercentCodec.Builder.of(QUERY).removeSafe('&').build();
        QUERY_PARAM_VALUE_STRICT = UNRESERVED;
        QUERY_PARAM_NAME = PercentCodec.Builder.of(QUERY_PARAM_VALUE).removeSafe('=').build();
        QUERY_PARAM_NAME_STRICT = UNRESERVED;
    }
}

