/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.map.reference;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import top.redscorpion.core.lang.ref.Ref;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsReference;

public abstract class ReferenceConcurrentMap<K, V>
implements ConcurrentMap<K, V>,
Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    final ConcurrentMap<Ref<K>, Ref<V>> raw;
    private final ReferenceQueue<K> lastKeyQueue;
    private final ReferenceQueue<V> lastValueQueue;
    private BiConsumer<Ref<? extends K>, Ref<? extends V>> purgeListener;

    public ReferenceConcurrentMap(ConcurrentMap<Ref<K>, Ref<V>> raw) {
        this.raw = raw;
        this.lastKeyQueue = new ReferenceQueue();
        this.lastValueQueue = new ReferenceQueue();
    }

    public void setPurgeListener(BiConsumer<Ref<? extends K>, Ref<? extends V>> purgeListener) {
        this.purgeListener = purgeListener;
    }

    @Override
    public int size() {
        this.purgeStale();
        return this.raw.size();
    }

    @Override
    public boolean isEmpty() {
        this.purgeStale();
        return this.raw.isEmpty();
    }

    @Override
    public V get(Object key) {
        this.purgeStale();
        return (V)ReferenceConcurrentMap.unwrap((Ref)this.raw.get(this.wrapKey(key)));
    }

    @Override
    public boolean containsKey(Object key) {
        this.purgeStale();
        return this.raw.containsKey(this.wrapKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.purgeStale();
        return this.raw.containsValue(this.wrapValue(value));
    }

    @Override
    public V put(K key, V value) {
        this.purgeStale();
        Ref<V> vReference = this.raw.put(this.wrapKey(key), this.wrapValue(value));
        return ReferenceConcurrentMap.unwrap(vReference);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.purgeStale();
        Ref<V> vReference = this.raw.putIfAbsent(this.wrapKey(key), this.wrapValue(value));
        return ReferenceConcurrentMap.unwrap(vReference);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public V replace(K key, V value) {
        this.purgeStale();
        Ref<V> vReference = this.raw.replace(this.wrapKey(key), this.wrapValue(value));
        return ReferenceConcurrentMap.unwrap(vReference);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.purgeStale();
        return this.raw.replace(this.wrapKey(key), this.wrapValue(oldValue), this.wrapValue(newValue));
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.purgeStale();
        this.raw.replaceAll((rKey, rValue) -> this.wrapValue(function.apply((K)ReferenceConcurrentMap.unwrap(rKey), (V)ReferenceConcurrentMap.unwrap(rValue))));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V result = null;
        while (null == result) {
            this.purgeStale();
            Ref vReference = this.raw.computeIfAbsent(this.wrapKey(key), kReference -> this.wrapValue(mappingFunction.apply((K)ReferenceConcurrentMap.unwrap(kReference))));
            if (NullRef.NULL == vReference) {
                return null;
            }
            result = (V)ReferenceConcurrentMap.unwrap(vReference);
        }
        return result;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = null;
        while (null == result) {
            this.purgeStale();
            Ref vReference = this.raw.computeIfPresent(this.wrapKey(key), (kReference, vReference1) -> this.wrapValue(remappingFunction.apply((K)ReferenceConcurrentMap.unwrap(kReference), (V)ReferenceConcurrentMap.unwrap(vReference1))));
            if (NullRef.NULL == vReference) {
                return null;
            }
            result = (V)ReferenceConcurrentMap.unwrap(vReference);
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        this.purgeStale();
        return (V)ReferenceConcurrentMap.unwrap((Ref)this.raw.remove(this.wrapKey(key)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.purgeStale();
        return this.raw.remove(this.wrapKey(key, null), value);
    }

    @Override
    public void clear() {
        this.raw.clear();
        while (this.lastKeyQueue.poll() != null) {
        }
        while (this.lastValueQueue.poll() != null) {
        }
    }

    @Override
    public Set<K> keySet() {
        this.purgeStale();
        final Set referenceSet = this.raw.keySet();
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator referenceIter = referenceSet.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return referenceIter.hasNext();
                    }

                    @Override
                    public K next() {
                        return ReferenceConcurrentMap.unwrap((Ref)referenceIter.next());
                    }
                };
            }

            @Override
            public int size() {
                return referenceSet.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        this.purgeStale();
        final Collection referenceValues = this.raw.values();
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator referenceIter = referenceValues.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return referenceIter.hasNext();
                    }

                    @Override
                    public V next() {
                        return ReferenceConcurrentMap.unwrap((Ref)referenceIter.next());
                    }
                };
            }

            @Override
            public int size() {
                return referenceValues.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.purgeStale();
        final Set referenceEntrySet = this.raw.entrySet();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator referenceIter = referenceEntrySet.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return referenceIter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry next = (Map.Entry)referenceIter.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return ReferenceConcurrentMap.unwrap((Ref)next.getKey());
                            }

                            @Override
                            public V getValue() {
                                return ReferenceConcurrentMap.unwrap((Ref)next.getValue());
                            }

                            @Override
                            public V setValue(V value) {
                                return ReferenceConcurrentMap.unwrap(next.setValue(ReferenceConcurrentMap.this.wrapValue(value)));
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return referenceEntrySet.size();
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.purgeStale();
        this.raw.forEach((? super K key, ? super V rValue) -> action.accept((Object)key.get(), (Object)ReferenceConcurrentMap.unwrap(rValue)));
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet().iterator();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.purgeStale();
        return (V)ReferenceConcurrentMap.unwrap(this.raw.compute(this.wrapKey(key), (kReference, vReference) -> this.wrapValue(remappingFunction.apply((K)ReferenceConcurrentMap.unwrap(kReference), (V)ReferenceConcurrentMap.unwrap(vReference)))));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.purgeStale();
        return (V)ReferenceConcurrentMap.unwrap(this.raw.merge(this.wrapKey(key), this.wrapValue(value), (vReference, vReference2) -> this.wrapValue(remappingFunction.apply((V)ReferenceConcurrentMap.unwrap(vReference), (V)ReferenceConcurrentMap.unwrap(vReference2)))));
    }

    private void purgeStale() {
        Ref value;
        Ref key;
        while ((key = (Ref)((Object)this.lastKeyQueue.poll())) != null) {
            value = (Ref)this.raw.remove(key);
            if (null == this.purgeListener) continue;
            this.purgeListener.accept(key, value);
        }
        while ((value = (Ref)((Object)this.lastValueQueue.poll())) != null) {
            RsMap.removeByValue(this.raw, value);
            if (null == this.purgeListener) continue;
            this.purgeListener.accept(null, value);
        }
    }

    abstract Ref<K> wrapKey(K var1, ReferenceQueue<? super K> var2);

    abstract Ref<V> wrapValue(V var1, ReferenceQueue<? super V> var2);

    private Ref<K> wrapKey(Object key) {
        return this.wrapKey(key, this.lastKeyQueue);
    }

    private Ref<V> wrapValue(Object value) {
        if (null == value) {
            return (Ref)NullRef.NULL;
        }
        return this.wrapValue(value, this.lastValueQueue);
    }

    private static <T> T unwrap(Ref<T> obj) {
        return RsReference.get(obj);
    }

    private static class NullRef
    implements Ref {
        public static final Object NULL = new NullRef();

        private NullRef() {
        }

        public Object get() {
            return null;
        }
    }
}

