/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.map.multi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import top.redscorpion.core.lang.Opt;
import top.redscorpion.core.map.MapWrapper;
import top.redscorpion.core.map.multi.MultiValueMap;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsObject;

public abstract class AbstractCollValueMap<K, V>
extends MapWrapper<K, Collection<V>>
implements MultiValueMap<K, V> {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_COLLECTION_INITIAL_CAPACITY = 3;

    protected AbstractCollValueMap(Supplier<Map<K, Collection<V>>> mapFactory) {
        super(mapFactory);
    }

    protected AbstractCollValueMap(Map<K, Collection<V>> map) {
        super(new HashMap<K, Collection<V>>(map));
    }

    protected AbstractCollValueMap() {
        super(new HashMap(16));
    }

    @Override
    public boolean putAllValues(K key, Collection<V> coll) {
        if (RsObject.isNull(coll)) {
            return false;
        }
        return super.computeIfAbsent(key, k -> this.createCollection()).addAll(coll);
    }

    @Override
    public boolean putValue(K key, V value) {
        return super.computeIfAbsent(key, k -> this.createCollection()).add(value);
    }

    @Override
    public boolean removeValue(K key, V value) {
        return Opt.ofNullable(super.get(key)).map(t -> t.remove(value)).orElse(false);
    }

    @Override
    public boolean removeAllValues(K key, Collection<V> values) {
        if (RsColl.isEmpty(values)) {
            return false;
        }
        Collection coll = (Collection)this.get(key);
        return RsObject.isNotNull(coll) && coll.removeAll(values);
    }

    @Override
    public MultiValueMap<K, V> filterAllValues(BiPredicate<K, V> filter) {
        this.entrySet().forEach((? super T e) -> {
            Object k = e.getKey();
            Collection coll = ((Collection)e.getValue()).stream().filter(v -> filter.test(k, v)).collect(Collectors.toCollection(this::createCollection));
            e.setValue(coll);
        });
        return this;
    }

    @Override
    public MultiValueMap<K, V> replaceAllValues(BiFunction<K, V, V> operate) {
        this.entrySet().forEach((? super T e) -> {
            Object k = e.getKey();
            Collection coll = ((Collection)e.getValue()).stream().map(v -> operate.apply(k, v)).collect(Collectors.toCollection(this::createCollection));
            e.setValue(coll);
        });
        return this;
    }

    protected abstract Collection<V> createCollection();
}

