/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import top.redscorpion.core.lang.Assert;

public class TripleTable<L, M, R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<L> lefts;
    private final List<M> middles;
    private final List<R> rights;

    public TripleTable(int size) {
        this(new ArrayList(size), new ArrayList(size), new ArrayList(size));
    }

    public TripleTable(List<L> lefts, List<M> middles, List<R> rights) {
        Assert.notNull(lefts);
        Assert.notNull(middles);
        Assert.notNull(rights);
        int size = lefts.size();
        if (size != middles.size() || size != rights.size()) {
            throw new IllegalArgumentException("List size must be equals!");
        }
        this.lefts = lefts;
        this.middles = middles;
        this.rights = rights;
    }

    public L getLeftByRight(R rValue) {
        int index = this.rights.indexOf(rValue);
        if (index > -1) {
            return this.lefts.get(index);
        }
        return null;
    }

    public M getMiddleByLeft(L lValue) {
        int index = this.lefts.indexOf(lValue);
        if (index > -1) {
            return this.middles.get(index);
        }
        return null;
    }
}

