/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang;

import java.util.NoSuchElementException;
import java.util.Objects;
import top.redscorpion.core.func.SerConsumer;
import top.redscorpion.core.func.SerFunction;
import top.redscorpion.core.func.SerSupplier;
import top.redscorpion.core.util.RsString;

public class Opt<T> {
    private static final Opt<?> EMPTY = new Opt<Object>(null);
    private final T value;
    private Throwable throwable;

    public static <T> Opt<T> empty() {
        Opt<?> t = EMPTY;
        return t;
    }

    public static <T> Opt<T> ofNullable(T value) {
        return value == null ? Opt.empty() : new Opt<T>(value);
    }

    public static <T> Opt<T> ofTry(SerSupplier<T> supplier) {
        try {
            return Opt.ofNullable(supplier.getting());
        }
        catch (Throwable e) {
            Opt<Object> empty = new Opt<Object>(null);
            empty.throwable = e;
            return empty;
        }
    }

    private Opt(T value) {
        this.value = value;
    }

    public T getOrNull() {
        return this.value;
    }

    public T getOrThrow() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isFail() {
        return null != this.throwable;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Opt<T> ifPresent(SerConsumer<? super T> action) {
        if (this.isPresent()) {
            try {
                action.accepting(this.value);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }
        return this;
    }

    public <U> Opt<U> map(SerFunction<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isFail()) {
            return this;
        }
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofTry(() -> mapper.applying((T)this.value));
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opt)) {
            return false;
        }
        Opt other = (Opt)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return RsString.toStringOrNull(this.value);
    }
}

