/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import top.redscorpion.core.io.resource.NoResourceException;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsUrl;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final long lastModified;
    private final String name;

    public FileResource(String path) {
        this(RsFile.file(path));
    }

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, null);
    }

    public FileResource(File file, String fileName) {
        this.file = Assert.notNull(file, "File must be not null !", new Object[0]);
        this.lastModified = file.lastModified();
        this.name = RsObject.defaultIfNull(fileName, file::getName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return RsUrl.getUrl(this.file);
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        if (!this.exists()) {
            throw new NoResourceException("File [{}] not exist!", new Object[]{this.file.getAbsolutePath()});
        }
        return RsFile.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.file.lastModified();
    }

    public String toString() {
        return this.file.toString();
    }
}

