/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import top.redscorpion.core.collection.iter.AbstractComputeIter;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.ReaderWrapper;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsString;

public class LineReader
extends ReaderWrapper
implements Iterable<String> {
    public LineReader(InputStream in, Charset charset) {
        this(RsIo.toReader(in, charset));
    }

    public LineReader(Reader reader) {
        super(RsIo.toBuffered(reader));
    }

    public String readLine() throws IOException {
        int c;
        StringBuilder str = null;
        boolean precedingBackslash = false;
        while ((c = this.read()) > 0) {
            if (null == str) {
                str = new StringBuilder(1024);
            }
            if (92 == c) {
                if (!precedingBackslash) {
                    precedingBackslash = true;
                    continue;
                }
                precedingBackslash = false;
            } else if (precedingBackslash) {
                if (RsChar.isBlankChar(c)) continue;
                precedingBackslash = false;
            } else if (10 == c) {
                int lastIndex = str.length() - 1;
                if (lastIndex < 0 || '\r' != str.charAt(lastIndex)) break;
                str.deleteCharAt(lastIndex);
                break;
            }
            str.append((char)c);
        }
        return RsString.toStringOrNull(str);
    }

    @Override
    public Iterator<String> iterator() {
        return new AbstractComputeIter<String>(){

            @Override
            protected String computeNext() {
                try {
                    return LineReader.this.readLine();
                }
                catch (IOException e) {
                    throw new IORuntimeException(e);
                }
            }
        };
    }
}

